/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import com.horcrux.svg.RNSVGMarkerType;
import com.horcrux.svg.SegmentData;
import java.util.ArrayList;

class RNSVGMarkerPosition {
    private static ArrayList<RNSVGMarkerPosition> positions_;
    private static int element_index_;
    private static Point origin_;
    private static Point subpath_start_;
    private static Point in_slope_;
    private static Point out_slope_;
    private static boolean auto_start_reverse_;
    RNSVGMarkerType type;
    Point origin;
    double angle;

    private RNSVGMarkerPosition(RNSVGMarkerType type, Point origin, double angle) {
        this.type = type;
        this.origin = origin;
        this.angle = angle;
    }

    static ArrayList<RNSVGMarkerPosition> fromPath(ArrayList<PathElement> elements) {
        positions_ = new ArrayList();
        element_index_ = 0;
        origin_ = new Point(0.0, 0.0);
        subpath_start_ = new Point(0.0, 0.0);
        for (PathElement e : elements) {
            RNSVGMarkerPosition.UpdateFromPathElement(e);
        }
        RNSVGMarkerPosition.PathIsDone();
        return positions_;
    }

    private static void PathIsDone() {
        double angle = RNSVGMarkerPosition.CurrentAngle(RNSVGMarkerType.kEndMarker);
        positions_.add(new RNSVGMarkerPosition(RNSVGMarkerType.kEndMarker, origin_, angle));
    }

    private static double BisectingAngle(double in_angle, double out_angle) {
        if (Math.abs(in_angle - out_angle) > 180.0) {
            in_angle += 360.0;
        }
        return (in_angle + out_angle) / 2.0;
    }

    private static double rad2deg(double rad) {
        double RNSVG_radToDeg = 57.29577951308232;
        return rad * RNSVG_radToDeg;
    }

    private static double SlopeAngleRadians(Point p) {
        return Math.atan2(p.y, p.x);
    }

    private static double CurrentAngle(RNSVGMarkerType type) {
        double in_angle = RNSVGMarkerPosition.rad2deg(RNSVGMarkerPosition.SlopeAngleRadians(in_slope_));
        double out_angle = RNSVGMarkerPosition.rad2deg(RNSVGMarkerPosition.SlopeAngleRadians(out_slope_));
        switch (type) {
            case kStartMarker: {
                if (auto_start_reverse_) {
                    out_angle += 180.0;
                }
                return out_angle;
            }
            case kMidMarker: {
                return RNSVGMarkerPosition.BisectingAngle(in_angle, out_angle);
            }
            case kEndMarker: {
                return in_angle;
            }
        }
        return 0.0;
    }

    private static Point subtract(Point p1, Point p2) {
        return new Point(p2.x - p1.x, p2.y - p1.y);
    }

    private static boolean isZero(Point p) {
        return p.x == 0.0 && p.y == 0.0;
    }

    private static void ComputeQuadTangents(SegmentData data, Point start, Point control, Point end) {
        data.start_tangent = RNSVGMarkerPosition.subtract(control, start);
        data.end_tangent = RNSVGMarkerPosition.subtract(end, control);
        if (RNSVGMarkerPosition.isZero(data.start_tangent)) {
            data.start_tangent = data.end_tangent;
        } else if (RNSVGMarkerPosition.isZero(data.end_tangent)) {
            data.end_tangent = data.start_tangent;
        }
    }

    private static SegmentData ExtractPathElementFeatures(PathElement element) {
        SegmentData data = new SegmentData();
        Point[] points = element.points;
        switch (element.type) {
            case kCGPathElementAddCurveToPoint: {
                data.position = points[2];
                data.start_tangent = RNSVGMarkerPosition.subtract(points[0], origin_);
                data.end_tangent = RNSVGMarkerPosition.subtract(points[2], points[1]);
                if (RNSVGMarkerPosition.isZero(data.start_tangent)) {
                    RNSVGMarkerPosition.ComputeQuadTangents(data, points[0], points[1], points[2]);
                    break;
                }
                if (!RNSVGMarkerPosition.isZero(data.end_tangent)) break;
                RNSVGMarkerPosition.ComputeQuadTangents(data, origin_, points[0], points[1]);
                break;
            }
            case kCGPathElementAddQuadCurveToPoint: {
                data.position = points[1];
                RNSVGMarkerPosition.ComputeQuadTangents(data, origin_, points[0], points[1]);
                break;
            }
            case kCGPathElementMoveToPoint: 
            case kCGPathElementAddLineToPoint: {
                data.position = points[0];
                data.start_tangent = RNSVGMarkerPosition.subtract(data.position, origin_);
                data.end_tangent = RNSVGMarkerPosition.subtract(data.position, origin_);
                break;
            }
            case kCGPathElementCloseSubpath: {
                data.position = subpath_start_;
                data.start_tangent = RNSVGMarkerPosition.subtract(data.position, origin_);
                data.end_tangent = RNSVGMarkerPosition.subtract(data.position, origin_);
            }
        }
        return data;
    }

    private static void UpdateFromPathElement(PathElement element) {
        SegmentData segment_data = RNSVGMarkerPosition.ExtractPathElementFeatures(element);
        out_slope_ = segment_data.start_tangent;
        if (element_index_ > 0) {
            RNSVGMarkerType marker_type = element_index_ == 1 ? RNSVGMarkerType.kStartMarker : RNSVGMarkerType.kMidMarker;
            double angle = RNSVGMarkerPosition.CurrentAngle(marker_type);
            positions_.add(new RNSVGMarkerPosition(marker_type, origin_, angle));
        }
        in_slope_ = segment_data.end_tangent;
        origin_ = segment_data.position;
        if (element.type == ElementType.kCGPathElementMoveToPoint) {
            subpath_start_ = element.points[0];
        } else if (element.type == ElementType.kCGPathElementCloseSubpath) {
            subpath_start_ = new Point(0.0, 0.0);
        }
        ++element_index_;
    }
}

