/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.horcrux.svg.Brush;
import com.horcrux.svg.DefinitionView;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class RadialGradientView
extends DefinitionView {
    private SVGLength mFx;
    private SVGLength mFy;
    private SVGLength mRx;
    private SVGLength mRy;
    private SVGLength mCx;
    private SVGLength mCy;
    private ReadableArray mGradient;
    private Brush.BrushUnits mGradientUnits;
    private static final float[] sRawMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private Matrix mMatrix = null;

    public RadialGradientView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setFx(Dynamic fx) {
        this.mFx = SVGLength.from(fx);
        this.invalidate();
    }

    public void setFy(Dynamic fy) {
        this.mFy = SVGLength.from(fy);
        this.invalidate();
    }

    public void setRx(Dynamic rx) {
        this.mRx = SVGLength.from(rx);
        this.invalidate();
    }

    public void setRy(Dynamic ry) {
        this.mRy = SVGLength.from(ry);
        this.invalidate();
    }

    public void setCx(Dynamic cx) {
        this.mCx = SVGLength.from(cx);
        this.invalidate();
    }

    public void setCy(Dynamic cy) {
        this.mCy = SVGLength.from(cy);
        this.invalidate();
    }

    public void setGradient(ReadableArray gradient) {
        this.mGradient = gradient;
        this.invalidate();
    }

    public void setGradientUnits(int gradientUnits) {
        switch (gradientUnits) {
            case 0: {
                this.mGradientUnits = Brush.BrushUnits.OBJECT_BOUNDING_BOX;
                break;
            }
            case 1: {
                this.mGradientUnits = Brush.BrushUnits.USER_SPACE_ON_USE;
            }
        }
        this.invalidate();
    }

    public void setGradientTransform(@Nullable ReadableArray matrixArray) {
        if (matrixArray != null) {
            int matrixSize = PropHelper.toMatrixData(matrixArray, sRawMatrix, this.mScale);
            if (matrixSize == 6) {
                if (this.mMatrix == null) {
                    this.mMatrix = new Matrix();
                }
                this.mMatrix.setValues(sRawMatrix);
            } else if (matrixSize != -1) {
                FLog.w((String)"ReactNative", (String)"RNSVG: Transform matrices must be of size 6");
            }
        } else {
            this.mMatrix = null;
        }
        this.invalidate();
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            SVGLength[] points = new SVGLength[]{this.mFx, this.mFy, this.mRx, this.mRy, this.mCx, this.mCy};
            Brush brush = new Brush(Brush.BrushType.RADIAL_GRADIENT, points, this.mGradientUnits);
            brush.setGradientColors(this.mGradient);
            if (this.mMatrix != null) {
                brush.setGradientTransform(this.mMatrix);
            }
            SvgView svg = this.getSvgView();
            if (this.mGradientUnits == Brush.BrushUnits.USER_SPACE_ON_USE) {
                brush.setUserSpaceBoundingBox(svg.getCanvasBounds());
            }
            svg.defineBrush(brush, this.mName);
        }
    }
}

