/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import androidx.annotation.Nullable;
import com.facebook.react.BaseReactPackage;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.uimanager.ViewManager;
import com.horcrux.svg.RNSVGRenderableManager;
import com.horcrux.svg.RenderableViewManager;
import com.horcrux.svg.SvgViewManager;
import com.horcrux.svg.SvgViewModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Provider;

public class SvgPackage
extends BaseReactPackage
implements ViewManagerOnDemandReactPackage {
    @Nullable
    private Map<String, ModuleSpec> mViewManagers;

    private Map<String, ModuleSpec> getViewManagersMap(ReactApplicationContext reactContext) {
        if (this.mViewManagers == null) {
            HashMap specs = MapBuilder.newHashMap();
            specs.put("RNSVGGroup", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.GroupViewManager();
                }
            }));
            specs.put("RNSVGPath", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.PathViewManager();
                }
            }));
            specs.put("RNSVGCircle", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.CircleViewManager();
                }
            }));
            specs.put("RNSVGEllipse", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.EllipseViewManager();
                }
            }));
            specs.put("RNSVGLine", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.LineViewManager();
                }
            }));
            specs.put("RNSVGRect", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.RectViewManager();
                }
            }));
            specs.put("RNSVGText", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.TextViewManager();
                }
            }));
            specs.put("RNSVGTSpan", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.TSpanViewManager();
                }
            }));
            specs.put("RNSVGTextPath", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.TextPathViewManager();
                }
            }));
            specs.put("RNSVGImage", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.ImageViewManager();
                }
            }));
            specs.put("RNSVGClipPath", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.ClipPathViewManager();
                }
            }));
            specs.put("RNSVGDefs", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.DefsViewManager();
                }
            }));
            specs.put("RNSVGUse", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.UseViewManager();
                }
            }));
            specs.put("RNSVGSymbol", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.SymbolManager();
                }
            }));
            specs.put("RNSVGLinearGradient", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.LinearGradientManager();
                }
            }));
            specs.put("RNSVGRadialGradient", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.RadialGradientManager();
                }
            }));
            specs.put("RNSVGPattern", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.PatternManager();
                }
            }));
            specs.put("RNSVGMask", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.MaskManager();
                }
            }));
            specs.put("RNSVGFilter", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FilterManager();
                }
            }));
            specs.put("RNSVGFeBlend", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeBlendManager();
                }
            }));
            specs.put("RNSVGFeColorMatrix", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeColorMatrixManager();
                }
            }));
            specs.put("RNSVGFeComposite", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeCompositeManager();
                }
            }));
            specs.put("RNSVGFeFlood", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeFloodManager();
                }
            }));
            specs.put("RNSVGFeGaussianBlur", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeGaussianBlurManager();
                }
            }));
            specs.put("RNSVGFeMerge", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeMergeManager();
                }
            }));
            specs.put("RNSVGFeOffset", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.FeOffsetManager();
                }
            }));
            specs.put("RNSVGForeignObject", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.ForeignObjectManager();
                }
            }));
            specs.put("RNSVGMarker", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new RenderableViewManager.MarkerManager();
                }
            }));
            specs.put("RNSVGSvgViewAndroid", ModuleSpec.viewManagerSpec((Provider)new Provider<NativeModule>(){

                public NativeModule get() {
                    return new SvgViewManager();
                }
            }));
            this.mViewManagers = specs;
        }
        return this.mViewManagers;
    }

    public List<String> getViewManagerNames(ReactApplicationContext reactContext) {
        return new ArrayList<String>(this.getViewManagersMap(reactContext).keySet());
    }

    protected List<ModuleSpec> getViewManagers(ReactApplicationContext reactContext) {
        return new ArrayList<ModuleSpec>(this.getViewManagersMap(reactContext).values());
    }

    @Nullable
    public ViewManager createViewManager(ReactApplicationContext reactContext, String viewManagerName) {
        ModuleSpec spec = this.getViewManagersMap(reactContext).get(viewManagerName);
        return spec != null ? (ViewManager)spec.getProvider().get() : null;
    }

    public NativeModule getModule(String name, @Nonnull ReactApplicationContext reactContext) {
        switch (name) {
            case "RNSVGSvgViewModule": {
                return new SvgViewModule(reactContext);
            }
            case "RNSVGRenderableModule": {
                return new RNSVGRenderableManager(reactContext);
            }
        }
        return null;
    }

    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        try {
            Class<?> reactModuleInfoProviderClass = Class.forName("com.horcrux.svg.SvgPackage$$ReactModuleInfoProvider");
            return (ReactModuleInfoProvider)reactModuleInfoProviderClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return new ReactModuleInfoProvider(){

                public Map<String, ReactModuleInfo> getReactModuleInfos() {
                    Class[] moduleList;
                    HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
                    for (Class moduleClass : moduleList = new Class[]{SvgViewModule.class, RNSVGRenderableManager.class}) {
                        ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                        reactModuleInfoMap.put(reactModule.name(), new ReactModuleInfo(reactModule.name(), moduleClass.getName(), reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), true));
                    }
                    return reactModuleInfoMap;
                }
            };
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for MyPackage$$ReactModuleInfoProvider", e);
        }
    }

    public List<Class<? extends JavaScriptModule>> createJSModules() {
        return Collections.emptyList();
    }
}

