/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Rect;
import android.util.SparseArray;
import android.view.ViewGroup;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.viewmanagers.RNSVGSvgViewAndroidManagerDelegate;
import com.facebook.react.viewmanagers.RNSVGSvgViewAndroidManagerInterface;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.view.ReactViewManager;
import com.horcrux.svg.SvgView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class SvgViewManager
extends ReactViewManager
implements RNSVGSvgViewAndroidManagerInterface<SvgView> {
    public static final String REACT_CLASS = "RNSVGSvgViewAndroid";
    private static final SparseArray<SvgView> mTagToSvgView = new SparseArray();
    private static final SparseArray<Runnable> mTagToRunnable = new SparseArray();
    private final ViewManagerDelegate<SvgView> mDelegate = new RNSVGSvgViewAndroidManagerDelegate(this);

    protected ViewManagerDelegate getDelegate() {
        return this.mDelegate;
    }

    static void setSvgView(int tag, SvgView svg) {
        mTagToSvgView.put(tag, (Object)svg);
        Runnable task = (Runnable)mTagToRunnable.get(tag);
        if (task != null) {
            task.run();
            mTagToRunnable.delete(tag);
        }
    }

    static void runWhenViewIsAvailable(int tag, Runnable task) {
        mTagToRunnable.put(tag, (Object)task);
    }

    @Nullable
    static SvgView getSvgViewByTag(int tag) {
        return (SvgView)((Object)mTagToSvgView.get(tag));
    }

    @Nonnull
    public String getName() {
        return REACT_CLASS;
    }

    @Nonnull
    public ReactViewGroup createViewInstance(ThemedReactContext reactContext) {
        return new SvgView((ReactContext)reactContext);
    }

    public void updateExtraData(ReactViewGroup root, Object extraData) {
        super.updateExtraData((ViewGroup)root, extraData);
        root.invalidate();
    }

    public void onDropViewInstance(@Nonnull ReactViewGroup view) {
        super.onDropViewInstance(view);
        mTagToSvgView.remove(view.getId());
    }

    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    @ReactProp(name="color", customType="Color")
    public void setColor(SvgView node, Integer color) {
        node.setCurrentColor(color);
    }

    @Override
    @ReactProp(name="minX")
    public void setMinX(SvgView node, float minX) {
        node.setMinX(minX);
    }

    @Override
    @ReactProp(name="minY")
    public void setMinY(SvgView node, float minY) {
        node.setMinY(minY);
    }

    @Override
    @ReactProp(name="vbWidth")
    public void setVbWidth(SvgView node, float vbWidth) {
        node.setVbWidth(vbWidth);
    }

    @Override
    @ReactProp(name="vbHeight")
    public void setVbHeight(SvgView node, float vbHeight) {
        node.setVbHeight(vbHeight);
    }

    @Override
    @ReactProp(name="bbWidth")
    public void setBbWidth(SvgView node, Dynamic bbWidth) {
        node.setBbWidth(bbWidth);
    }

    @Override
    @ReactProp(name="bbHeight")
    public void setBbHeight(SvgView node, Dynamic bbHeight) {
        node.setBbHeight(bbHeight);
    }

    @Override
    @ReactProp(name="align")
    public void setAlign(SvgView node, String align) {
        node.setAlign(align);
    }

    @Override
    @ReactProp(name="meetOrSlice")
    public void setMeetOrSlice(SvgView node, int meetOrSlice) {
        node.setMeetOrSlice(meetOrSlice);
    }

    @Override
    @ReactProp(name="pointerEvents")
    public void setPointerEvents(SvgView view, @Nullable String pointerEventsStr) {
        try {
            Class<?> superclass = ((Object)((Object)view)).getClass().getSuperclass();
            if (superclass != null) {
                Method method = superclass.getDeclaredMethod("setPointerEvents", PointerEvents.class);
                method.setAccessible(true);
                method.invoke((Object)view, PointerEvents.valueOf((String)pointerEventsStr.toUpperCase(Locale.US).replace("-", "_")));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setHasTVPreferredFocus(SvgView view, boolean value) {
        super.setTVPreferredFocus((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderBottomColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 4, value);
    }

    @Override
    public void setNextFocusDown(SvgView view, int value) {
        super.nextFocusDown((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderRightColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 2, value);
    }

    @Override
    public void setNextFocusRight(SvgView view, int value) {
        super.nextFocusRight((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderLeftColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 1, value);
    }

    @Override
    public void setBorderColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 0, value);
    }

    @Override
    public void setRemoveClippedSubviews(SvgView view, boolean value) {
        super.setRemoveClippedSubviews((ReactViewGroup)view, value);
    }

    @Override
    public void setNextFocusForward(SvgView view, int value) {
        super.nextFocusForward((ReactViewGroup)view, value);
    }

    @Override
    public void setNextFocusUp(SvgView view, int value) {
        super.nextFocusUp((ReactViewGroup)view, value);
    }

    @Override
    public void setAccessible(SvgView view, boolean value) {
        super.setAccessible((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderStartColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 5, value);
    }

    @Override
    public void setBorderEndColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 6, value);
    }

    @Override
    public void setFocusable(SvgView view, boolean value) {
        super.setFocusable((ReactViewGroup)view, value);
    }

    @Override
    public void setNativeBackgroundAndroid(SvgView view, @Nullable ReadableMap value) {
        super.setNativeBackground((ReactViewGroup)view, value);
    }

    @Override
    public void setNativeForegroundAndroid(SvgView view, @Nullable ReadableMap value) {
        super.setNativeForeground((ReactViewGroup)view, value);
    }

    @Override
    public void setBackfaceVisibility(SvgView view, @Nullable String value) {
        super.setBackfaceVisibility((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderStyle(SvgView view, @Nullable String value) {
        super.setBorderStyle((ReactViewGroup)view, value);
    }

    @Override
    public void setNeedsOffscreenAlphaCompositing(SvgView view, boolean value) {
        super.setNeedsOffscreenAlphaCompositing((ReactViewGroup)view, value);
    }

    @Override
    public void setHitSlop(SvgView view, Dynamic hitSlop) {
        switch (hitSlop.getType()) {
            case Map: {
                ReadableMap hitSlopMap = hitSlop.asMap();
                view.setHitSlopRect(new Rect(hitSlopMap.hasKey("left") ? (int)PixelUtil.toPixelFromDIP((double)hitSlopMap.getDouble("left")) : 0, hitSlopMap.hasKey("top") ? (int)PixelUtil.toPixelFromDIP((double)hitSlopMap.getDouble("top")) : 0, hitSlopMap.hasKey("right") ? (int)PixelUtil.toPixelFromDIP((double)hitSlopMap.getDouble("right")) : 0, hitSlopMap.hasKey("bottom") ? (int)PixelUtil.toPixelFromDIP((double)hitSlopMap.getDouble("bottom")) : 0));
                break;
            }
            case Number: {
                int hitSlopValue = (int)PixelUtil.toPixelFromDIP((double)hitSlop.asDouble());
                view.setHitSlopRect(new Rect(hitSlopValue, hitSlopValue, hitSlopValue, hitSlopValue));
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid type for 'hitSlop' value " + hitSlop.getType()));
            }
            case Null: {
                view.setHitSlopRect(null);
            }
        }
    }

    @Override
    public void setBorderTopColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 3, value);
    }

    @Override
    public void setNextFocusLeft(SvgView view, int value) {
        super.nextFocusLeft((ReactViewGroup)view, value);
    }

    @Override
    public void setBorderBlockColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 9, value);
    }

    @Override
    public void setBorderBlockEndColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 10, value);
    }

    @Override
    public void setBorderBlockStartColor(SvgView view, @Nullable Integer value) {
        super.setBorderColor((ReactViewGroup)view, 11, value);
    }

    @Override
    public void setBorderRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 0, rawBorderRadius);
    }

    @Override
    public void setBorderTopLeftRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 1, rawBorderRadius);
    }

    @Override
    public void setBorderTopRightRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 2, rawBorderRadius);
    }

    @Override
    public void setBorderBottomRightRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 3, rawBorderRadius);
    }

    @Override
    public void setBorderBottomLeftRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 4, rawBorderRadius);
    }

    @Override
    public void setBorderTopStartRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 5, rawBorderRadius);
    }

    @Override
    public void setBorderTopEndRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 6, rawBorderRadius);
    }

    @Override
    public void setBorderBottomStartRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 7, rawBorderRadius);
    }

    @Override
    public void setBorderBottomEndRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 8, rawBorderRadius);
    }

    @Override
    public void setBorderEndEndRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 9, rawBorderRadius);
    }

    @Override
    public void setBorderEndStartRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 10, rawBorderRadius);
    }

    @Override
    public void setBorderStartEndRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 11, rawBorderRadius);
    }

    @Override
    public void setBorderStartStartRadius(SvgView view, Dynamic rawBorderRadius) {
        super.setBorderRadius((ReactViewGroup)view, 12, rawBorderRadius);
    }
}

