/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;
import com.horcrux.svg.NativeSvgViewModuleSpec;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.SvgViewManager;
import javax.annotation.Nonnull;

@ReactModule(name="RNSVGSvgViewModule")
class SvgViewModule
extends NativeSvgViewModuleSpec {
    public static final String NAME = "RNSVGSvgViewModule";

    SvgViewModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    private static void toDataURL(final int tag, final ReadableMap options, final Callback successCallback, final int attempt) {
        UiThreadUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SvgView svg = SvgViewManager.getSvgViewByTag(tag);
                if (svg == null) {
                    SvgViewManager.runWhenViewIsAvailable(tag, new Runnable(){

                        @Override
                        public void run() {
                            SvgView svg = SvgViewManager.getSvgViewByTag(tag);
                            if (svg == null) {
                                return;
                            }
                            svg.setToDataUrlTask(new Runnable(){

                                @Override
                                public void run() {
                                    SvgViewModule.toDataURL(tag, options, successCallback, attempt + 1);
                                }
                            });
                        }
                    });
                } else if (svg.notRendered()) {
                    svg.setToDataUrlTask(new Runnable(){

                        @Override
                        public void run() {
                            SvgViewModule.toDataURL(tag, options, successCallback, attempt + 1);
                        }
                    });
                } else if (options != null) {
                    successCallback.invoke(new Object[]{svg.toDataURL(options.getInt("width"), options.getInt("height"))});
                } else {
                    successCallback.invoke(new Object[]{svg.toDataURL()});
                }
            }
        });
    }

    @Override
    @ReactMethod
    public void toDataURL(Double tag, ReadableMap options, Callback successCallback) {
        SvgViewModule.toDataURL(tag.intValue(), options, successCallback, 0);
    }
}

