/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.SpannableString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.views.text.ReactFontManager;
import com.horcrux.svg.FontData;
import com.horcrux.svg.GlyphContext;
import com.horcrux.svg.GlyphPathBag;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.TextPathView;
import com.horcrux.svg.TextProperties;
import com.horcrux.svg.TextView;
import java.text.Bidi;
import java.util.ArrayList;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class TSpanView
extends TextView {
    private static final double tau = Math.PI * 2;
    private static final double radToDeg = 57.29577951308232;
    private static final String FONTS = "fonts/";
    private static final String OTF = ".otf";
    private static final String TTF = ".ttf";
    private Path mCachedPath;
    @Nullable
    String mContent;
    private TextPathView textPath;
    private final ArrayList<String> emoji = new ArrayList();
    private final ArrayList<Matrix> emojiTransforms = new ArrayList();
    private final AssetManager assets = this.mContext.getResources().getAssets();
    static final String requiredFontFeatures = "'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk',";
    static final String disableDiscretionaryLigatures = "'liga' 0, 'clig' 0, 'dlig' 0, 'hlig' 0, 'cala' 0, ";
    static final String defaultFeatures = "'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk','kern', ";
    static final String additionalLigatures = "'hlig', 'cala', ";
    static final String fontWeightTag = "'wght' ";

    public TSpanView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setContent(@Nullable String content) {
        this.mContent = content;
        this.invalidate();
    }

    @Override
    public void invalidate() {
        this.mCachedPath = null;
        super.invalidate();
    }

    @Override
    void clearCache() {
        this.mCachedPath = null;
        super.clearCache();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        if (this.mContent != null) {
            if (this.mInlineSize != null && this.mInlineSize.value != 0.0) {
                if (this.setupFillPaint(paint, opacity * this.fillOpacity)) {
                    this.drawWrappedText(canvas, paint);
                }
                if (this.setupStrokePaint(paint, opacity * this.strokeOpacity)) {
                    this.drawWrappedText(canvas, paint);
                }
            } else {
                int numEmoji = this.emoji.size();
                if (numEmoji > 0) {
                    GlyphContext gc = this.getTextRootGlyphContext();
                    FontData font = gc.getFont();
                    this.applyTextPropertiesToPaint(paint, font);
                    for (int i = 0; i < numEmoji; ++i) {
                        String current = this.emoji.get(i);
                        Matrix mid = this.emojiTransforms.get(i);
                        canvas.save();
                        canvas.concat(mid);
                        canvas.drawText(current, 0.0f, 0.0f, paint);
                        canvas.restore();
                    }
                }
                this.drawPath(canvas, paint, opacity);
            }
        } else {
            this.clip(canvas, paint);
            this.drawGroup(canvas, paint, opacity);
        }
    }

    private void drawWrappedText(Canvas canvas, Paint paint) {
        GlyphContext gc = this.getTextRootGlyphContext();
        this.pushGlyphContext();
        FontData font = gc.getFont();
        TextPaint tp = new TextPaint(paint);
        this.applyTextPropertiesToPaint((Paint)tp, font);
        this.applySpacingAndFeatures((Paint)tp, font);
        double fontSize = gc.getFontSize();
        Layout.Alignment align = switch (font.textAnchor) {
            default -> Layout.Alignment.ALIGN_NORMAL;
            case TextProperties.TextAnchor.middle -> Layout.Alignment.ALIGN_CENTER;
            case TextProperties.TextAnchor.end -> Layout.Alignment.ALIGN_OPPOSITE;
        };
        boolean includeFontPadding = true;
        SpannableString text = new SpannableString((CharSequence)this.mContent);
        double width = PropHelper.fromRelative(this.mInlineSize, canvas.getWidth(), 0.0, this.mScale, fontSize);
        StaticLayout layout = this.getStaticLayout(tp, align, includeFontPadding, text, (int)width);
        int lineAscent = layout.getLineAscent(0);
        float dx = (float)gc.nextX(0.0);
        float dy = (float)(gc.nextY() + (double)lineAscent);
        this.popGlyphContext();
        canvas.save();
        canvas.translate(dx, dy);
        layout.draw(canvas);
        canvas.restore();
    }

    private StaticLayout getStaticLayout(TextPaint tp, Layout.Alignment align, boolean includeFontPadding, SpannableString text, int width) {
        if (Build.VERSION.SDK_INT < 23) {
            return new StaticLayout((CharSequence)text, tp, width, align, 1.0f, 0.0f, includeFontPadding);
        }
        return StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)tp, (int)width).setAlignment(align).setLineSpacing(0.0f, 1.0f).setIncludePad(includeFontPadding).setBreakStrategy(1).setHyphenationFrequency(1).build();
    }

    public static String visualToLogical(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Bidi bidi = new Bidi(text, -2);
        if (bidi.isLeftToRight()) {
            return text;
        }
        int count = bidi.getRunCount();
        byte[] levels = new byte[count];
        Object[] runs = new Integer[count];
        for (int i = 0; i < count; ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
            runs[i] = i;
        }
        Bidi.reorderVisually(levels, 0, runs, 0, count);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int index = (Integer)runs[i];
            int start = bidi.getRunStart(index);
            int end = bidi.getRunLimit(index);
            byte level = levels[index];
            if ((level & 1) != 0) {
                while (--end >= start) {
                    result.append(text.charAt(end));
                }
                continue;
            }
            result.append(text, start, end);
        }
        return result.toString();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        if (this.mCachedPath != null) {
            return this.mCachedPath;
        }
        if (this.mContent == null) {
            this.mCachedPath = this.getGroupPath(canvas, paint);
            return this.mCachedPath;
        }
        this.setupTextPath();
        this.pushGlyphContext();
        this.mCachedPath = this.getLinePath(TSpanView.visualToLogical(this.mContent), paint, canvas);
        this.popGlyphContext();
        return this.mCachedPath;
    }

    @Override
    double getSubtreeTextChunksTotalAdvance(Paint paint) {
        if (!Double.isNaN(this.cachedAdvance)) {
            return this.cachedAdvance;
        }
        double advance = 0.0;
        if (this.mContent == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (!(child instanceof TextView)) continue;
                TextView text = (TextView)child;
                advance += text.getSubtreeTextChunksTotalAdvance(paint);
            }
            this.cachedAdvance = advance;
            return advance;
        }
        String line = this.mContent;
        int length = line.length();
        if (length == 0) {
            this.cachedAdvance = 0.0;
            return advance;
        }
        GlyphContext gc = this.getTextRootGlyphContext();
        FontData font = gc.getFont();
        this.applyTextPropertiesToPaint(paint, font);
        this.applySpacingAndFeatures(paint, font);
        this.cachedAdvance = paint.measureText(line);
        return this.cachedAdvance;
    }

    private void applySpacingAndFeatures(Paint paint, FontData font) {
        if (Build.VERSION.SDK_INT >= 21) {
            boolean allowOptionalLigatures;
            double letterSpacing = font.letterSpacing;
            paint.setLetterSpacing((float)(letterSpacing / (font.fontSize * (double)this.mScale)));
            boolean bl = allowOptionalLigatures = letterSpacing == 0.0 && font.fontVariantLigatures == TextProperties.FontVariantLigatures.normal;
            if (allowOptionalLigatures) {
                paint.setFontFeatureSettings("'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk','kern', 'hlig', 'cala', " + font.fontFeatureSettings);
            } else {
                paint.setFontFeatureSettings("'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk','kern', 'liga' 0, 'clig' 0, 'dlig' 0, 'hlig' 0, 'cala' 0, " + font.fontFeatureSettings);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                paint.setFontVariationSettings(fontWeightTag + font.absoluteFontWeight + font.fontVariationSettings);
            }
        }
    }

    private Path getLinePath(String line, Paint paint, Canvas canvas) {
        boolean allowOptionalLigatures;
        boolean hasTextPath;
        int length = line.length();
        Path path = new Path();
        this.emoji.clear();
        this.emojiTransforms.clear();
        if (length == 0) {
            return path;
        }
        double pathLength = 0.0;
        PathMeasure pm = null;
        boolean isClosed = false;
        boolean bl = hasTextPath = this.textPath != null;
        if (hasTextPath) {
            pm = new PathMeasure(this.textPath.getTextPath(canvas, paint), false);
            pathLength = pm.getLength();
            isClosed = pm.isClosed();
            if (pathLength == 0.0) {
                return path;
            }
        }
        GlyphContext gc = this.getTextRootGlyphContext();
        FontData font = gc.getFont();
        this.applyTextPropertiesToPaint(paint, font);
        GlyphPathBag bag = new GlyphPathBag(paint);
        boolean[] ligature = new boolean[length];
        char[] chars = line.toCharArray();
        double kerning = font.kerning;
        double wordSpacing = font.wordSpacing;
        double letterSpacing = font.letterSpacing;
        boolean autoKerning = !font.manualKerning;
        boolean bl2 = allowOptionalLigatures = letterSpacing == 0.0 && font.fontVariantLigatures == TextProperties.FontVariantLigatures.normal;
        if (Build.VERSION.SDK_INT >= 21) {
            if (allowOptionalLigatures) {
                paint.setFontFeatureSettings("'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk','kern', 'hlig', 'cala', " + font.fontFeatureSettings);
            } else {
                paint.setFontFeatureSettings("'rlig', 'liga', 'clig', 'calt', 'locl', 'ccmp', 'mark', 'mkmk','kern', 'liga' 0, 'clig' 0, 'dlig' 0, 'hlig' 0, 'cala' 0, " + font.fontFeatureSettings);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                paint.setFontVariationSettings(fontWeightTag + font.absoluteFontWeight + font.fontVariationSettings);
            }
        }
        ReadableMap fontData = font.fontData;
        float[] advances = new float[length];
        paint.getTextWidths(line, advances);
        TextProperties.TextAnchor textAnchor = font.textAnchor;
        TextView anchorRoot = this.getTextAnchorRoot();
        double textMeasure = anchorRoot.getSubtreeTextChunksTotalAdvance(paint);
        double offset = this.getTextAnchorOffset(textAnchor, textMeasure);
        int side = 1;
        double startOfRendering = 0.0;
        double endOfRendering = pathLength;
        double fontSize = gc.getFontSize();
        boolean sharpMidLine = false;
        if (hasTextPath) {
            sharpMidLine = this.textPath.getMidLine() == TextProperties.TextPathMidLine.sharp;
            side = this.textPath.getSide() == TextProperties.TextPathSide.right ? -1 : 1;
            double absoluteStartOffset = this.getAbsoluteStartOffset(this.textPath.getStartOffset(), pathLength, fontSize);
            offset += absoluteStartOffset;
            if (isClosed) {
                double halfPathDistance = pathLength / 2.0;
                startOfRendering = absoluteStartOffset + (textAnchor == TextProperties.TextAnchor.middle ? -halfPathDistance : 0.0);
                endOfRendering = startOfRendering + pathLength;
            }
        }
        double scaleSpacingAndGlyphs = 1.0;
        if (this.mTextLength != null) {
            double author = PropHelper.fromRelative(this.mTextLength, canvas.getWidth(), 0.0, this.mScale, fontSize);
            if (author < 0.0) {
                throw new IllegalArgumentException("Negative textLength value");
            }
            switch (this.mLengthAdjust) {
                default: {
                    letterSpacing += (author - textMeasure) / (double)(length - 1);
                    break;
                }
                case spacingAndGlyphs: {
                    scaleSpacingAndGlyphs = author / textMeasure;
                }
            }
        }
        double scaledDirection = scaleSpacingAndGlyphs * (double)side;
        Paint.FontMetrics fm = paint.getFontMetrics();
        double descenderDepth = fm.descent;
        double bottom = descenderDepth + (double)fm.leading;
        double ascenderHeight = -fm.ascent + fm.leading;
        double top = -fm.top;
        double totalHeight = top + bottom;
        double baselineShift = 0.0;
        String baselineShiftString = this.getBaselineShift();
        TextProperties.AlignmentBaseline baseline = this.getAlignmentBaseline();
        if (baseline != null) {
            switch (baseline) {
                default: {
                    baselineShift = 0.0;
                    break;
                }
                case textBottom: 
                case afterEdge: 
                case textAfterEdge: {
                    baselineShift = -descenderDepth;
                    break;
                }
                case alphabetic: {
                    baselineShift = 0.0;
                    break;
                }
                case ideographic: {
                    baselineShift = -descenderDepth;
                    break;
                }
                case middle: {
                    Object bounds = new Rect();
                    paint.getTextBounds("x", 0, 1, (Rect)bounds);
                    int xHeight = bounds.height();
                    baselineShift = (double)xHeight / 2.0;
                    break;
                }
                case central: {
                    baselineShift = (ascenderHeight - descenderDepth) / 2.0;
                    break;
                }
                case mathematical: {
                    baselineShift = 0.5 * ascenderHeight;
                    break;
                }
                case hanging: {
                    baselineShift = 0.8 * ascenderHeight;
                    break;
                }
                case textTop: 
                case beforeEdge: 
                case textBeforeEdge: {
                    baselineShift = ascenderHeight;
                    break;
                }
                case bottom: {
                    baselineShift = bottom;
                    break;
                }
                case center: {
                    baselineShift = totalHeight / 2.0;
                    break;
                }
                case top: {
                    baselineShift = top;
                }
            }
        }
        if (baselineShiftString != null && !baselineShiftString.isEmpty()) {
            block16 : switch (baseline) {
                case bottom: 
                case top: {
                    break;
                }
                default: {
                    switch (baselineShiftString) {
                        case "sub": {
                            ReadableMap os2;
                            if (fontData == null || !fontData.hasKey("tables") || !fontData.hasKey("unitsPerEm")) break block16;
                            int unitsPerEm = fontData.getInt("unitsPerEm");
                            ReadableMap tables = fontData.getMap("tables");
                            if (!tables.hasKey("os2") || !(os2 = tables.getMap("os2")).hasKey("ySubscriptYOffset")) break block16;
                            double subOffset = os2.getDouble("ySubscriptYOffset");
                            baselineShift += (double)this.mScale * fontSize * subOffset / (double)unitsPerEm;
                            break block16;
                        }
                        case "super": {
                            ReadableMap os2;
                            if (fontData == null || !fontData.hasKey("tables") || !fontData.hasKey("unitsPerEm")) break block16;
                            int unitsPerEm = fontData.getInt("unitsPerEm");
                            ReadableMap tables = fontData.getMap("tables");
                            if (!tables.hasKey("os2") || !(os2 = tables.getMap("os2")).hasKey("ySuperscriptYOffset")) break block16;
                            double superOffset = os2.getDouble("ySuperscriptYOffset");
                            baselineShift -= (double)this.mScale * fontSize * superOffset / (double)unitsPerEm;
                            break block16;
                        }
                        case "baseline": {
                            break block16;
                        }
                        default: {
                            baselineShift -= PropHelper.fromRelative(baselineShiftString, (double)this.mScale * fontSize, this.mScale, fontSize);
                        }
                    }
                }
            }
        }
        Matrix start = new Matrix();
        Matrix mid = new Matrix();
        Matrix end = new Matrix();
        float[] startPointMatrixData = new float[9];
        float[] endPointMatrixData = new float[9];
        for (int index = 0; index < length; ++index) {
            Path glyph;
            char currentChar = chars[index];
            String current = String.valueOf(currentChar);
            boolean alreadyRenderedGraphemeCluster = ligature[index];
            boolean hasLigature = false;
            if (alreadyRenderedGraphemeCluster) {
                current = "";
            } else {
                float nextWidth;
                int nextIndex = index;
                while (++nextIndex < length && !((nextWidth = advances[nextIndex]) > 0.0f)) {
                    String nextLigature = current + chars[nextIndex];
                    ligature[nextIndex] = true;
                    current = nextLigature;
                    hasLigature = true;
                }
            }
            double charWidth = (double)paint.measureText(current) * scaleSpacingAndGlyphs;
            if (autoKerning) {
                double kerned = (double)advances[index] * scaleSpacingAndGlyphs;
                kerning = kerned - charWidth;
            }
            boolean isWordSeparator = currentChar == ' ';
            double wordSpace = isWordSeparator ? wordSpacing : 0.0;
            double spacing = wordSpace + letterSpacing;
            double advance = charWidth + spacing;
            double x = gc.nextX(alreadyRenderedGraphemeCluster ? 0.0 : kerning + advance);
            double y = gc.nextY();
            double dx = gc.nextDeltaX();
            double dy = gc.nextDeltaY();
            double r = gc.nextRotation();
            if (alreadyRenderedGraphemeCluster || isWordSeparator) continue;
            charWidth *= (double)side;
            double cursor = offset + (x + dx) * (double)side;
            double startPoint = cursor - (advance *= (double)side);
            if (hasTextPath) {
                double endPoint = startPoint + charWidth;
                double halfWay = charWidth / 2.0;
                double midPoint = startPoint + halfWay;
                if (midPoint > endOfRendering || midPoint < startOfRendering) continue;
                int posAndTanFlags = 3;
                if (sharpMidLine) {
                    pm.getMatrix((float)midPoint, mid, 3);
                } else {
                    if (startPoint < 0.0) {
                        pm.getMatrix(0.0f, start, 3);
                        start.preTranslate((float)startPoint, 0.0f);
                    } else {
                        pm.getMatrix((float)startPoint, start, 1);
                    }
                    pm.getMatrix((float)midPoint, mid, 1);
                    if (endPoint > pathLength) {
                        pm.getMatrix((float)pathLength, end, 3);
                        end.preTranslate((float)(endPoint - pathLength), 0.0f);
                    } else {
                        pm.getMatrix((float)endPoint, end, 1);
                    }
                    start.getValues(startPointMatrixData);
                    end.getValues(endPointMatrixData);
                    double startX = startPointMatrixData[2];
                    double startY = startPointMatrixData[5];
                    double endX = endPointMatrixData[2];
                    double endY = endPointMatrixData[5];
                    double lineX = endX - startX;
                    double lineY = endY - startY;
                    double glyphMidlineAngle = Math.atan2(lineY, lineX);
                    mid.preRotate((float)(glyphMidlineAngle * 57.29577951308232 * (double)side));
                }
                mid.preTranslate((float)(-halfWay), (float)(dy + baselineShift));
                mid.preScale((float)scaledDirection, (float)side);
                mid.postTranslate(0.0f, (float)y);
            } else {
                mid.setTranslate((float)startPoint, (float)(y + dy + baselineShift));
            }
            mid.preRotate((float)r);
            if (hasLigature) {
                glyph = new Path();
                paint.getTextPath(current, 0, current.length(), 0.0f, 0.0f, glyph);
            } else {
                glyph = bag.getOrCreateAndCache(currentChar, current);
            }
            RectF bounds = new RectF();
            glyph.computeBounds(bounds, true);
            float width = bounds.width();
            if (width == 0.0f) {
                canvas.save();
                canvas.concat(mid);
                this.emoji.add(current);
                this.emojiTransforms.add(new Matrix(mid));
                canvas.drawText(current, 0.0f, 0.0f, paint);
                canvas.restore();
                continue;
            }
            glyph.transform(mid);
            path.addPath(glyph);
        }
        return path;
    }

    private double getAbsoluteStartOffset(SVGLength startOffset, double distance, double fontSize) {
        return PropHelper.fromRelative(startOffset, distance, 0.0, this.mScale, fontSize);
    }

    private double getTextAnchorOffset(TextProperties.TextAnchor textAnchor, double textMeasure) {
        switch (textAnchor) {
            default: {
                return 0.0;
            }
            case middle: {
                return -textMeasure / 2.0;
            }
            case end: 
        }
        return -textMeasure;
    }

    private void applyTextPropertiesToPaint(Paint paint, FontData font) {
        boolean isItalic;
        boolean isBold = font.fontWeight == TextProperties.FontWeight.Bold || font.absoluteFontWeight >= 550;
        boolean bl = isItalic = font.fontStyle == TextProperties.FontStyle.italic;
        int style = isBold && isItalic ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
        Typeface typeface = null;
        int weight = font.absoluteFontWeight;
        String fontFamily = font.fontFamily;
        if (fontFamily != null && fontFamily.length() > 0) {
            String otfpath = FONTS + fontFamily + OTF;
            String ttfpath = FONTS + fontFamily + TTF;
            if (Build.VERSION.SDK_INT >= 26) {
                Typeface.Builder builder = new Typeface.Builder(this.assets, otfpath);
                builder.setFontVariationSettings(fontWeightTag + weight + font.fontVariationSettings);
                builder.setWeight(weight);
                builder.setItalic(isItalic);
                typeface = builder.build();
                if (typeface == null) {
                    builder = new Typeface.Builder(this.assets, ttfpath);
                    builder.setFontVariationSettings(fontWeightTag + weight + font.fontVariationSettings);
                    builder.setWeight(weight);
                    builder.setItalic(isItalic);
                    typeface = builder.build();
                }
            } else {
                try {
                    typeface = Typeface.createFromAsset((AssetManager)this.assets, (String)otfpath);
                    typeface = Typeface.create((Typeface)typeface, (int)style);
                }
                catch (Exception ignored) {
                    try {
                        typeface = Typeface.createFromAsset((AssetManager)this.assets, (String)ttfpath);
                        typeface = Typeface.create((Typeface)typeface, (int)style);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (typeface == null) {
            try {
                typeface = ReactFontManager.getInstance().getTypeface(fontFamily, style, this.assets);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Build.VERSION.SDK_INT >= 28) {
            typeface = Typeface.create(typeface, (int)weight, (boolean)isItalic);
        }
        paint.setLinearText(true);
        paint.setSubpixelText(true);
        paint.setTypeface(typeface);
        paint.setTextSize((float)(font.fontSize * (double)this.mScale));
        if (Build.VERSION.SDK_INT >= 21) {
            paint.setLetterSpacing(0.0f);
        }
    }

    private void setupTextPath() {
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getClass() == TextPathView.class) {
                this.textPath = (TextPathView)parent;
                break;
            }
            if (!(parent instanceof TextView)) break;
        }
    }

    @Override
    int hitTest(float[] src) {
        if (this.mContent == null) {
            return super.hitTest(src);
        }
        if (this.mPath == null || !this.mInvertible) {
            return -1;
        }
        float[] dst = new float[2];
        this.mInvMatrix.mapPoints(dst, src);
        this.mInvTransform.mapPoints(dst);
        int x = Math.round(dst[0]);
        int y = Math.round(dst[1]);
        this.initBounds();
        if (!(this.mRegion != null && this.mRegion.contains(x, y) || this.mStrokeRegion != null && this.mStrokeRegion.contains(x, y))) {
            return -1;
        }
        Path clipPath = this.getClipPath();
        if (clipPath != null && !this.mClipRegion.contains(x, y)) {
            return -1;
        }
        return this.getId();
    }
}

