/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.TextProperties;
import com.horcrux.svg.TextView;
import com.horcrux.svg.VirtualView;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class TextPathView
extends TextView {
    private String mHref;
    private TextProperties.TextPathSide mSide;
    private TextProperties.TextPathMidLine mMidLine;
    @Nullable
    private SVGLength mStartOffset;
    private TextProperties.TextPathMethod mMethod = TextProperties.TextPathMethod.align;
    private TextProperties.TextPathSpacing mSpacing = TextProperties.TextPathSpacing.exact;

    public TextPathView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setHref(String href) {
        this.mHref = href;
        this.invalidate();
    }

    public void setStartOffset(Dynamic startOffset) {
        this.mStartOffset = SVGLength.from(startOffset);
        this.invalidate();
    }

    @Override
    public void setMethod(@Nullable String method) {
        this.mMethod = TextProperties.TextPathMethod.valueOf(method);
        this.invalidate();
    }

    public void setSpacing(@Nullable String spacing) {
        this.mSpacing = TextProperties.TextPathSpacing.valueOf(spacing);
        this.invalidate();
    }

    public void setSide(@Nullable String side) {
        this.mSide = TextProperties.TextPathSide.valueOf(side);
        this.invalidate();
    }

    public void setSharp(@Nullable String midLine) {
        this.mMidLine = TextProperties.TextPathMidLine.valueOf(midLine);
        this.invalidate();
    }

    TextProperties.TextPathMethod getMethod() {
        return this.mMethod;
    }

    TextProperties.TextPathSpacing getSpacing() {
        return this.mSpacing;
    }

    TextProperties.TextPathSide getSide() {
        return this.mSide;
    }

    TextProperties.TextPathMidLine getMidLine() {
        return this.mMidLine;
    }

    SVGLength getStartOffset() {
        return this.mStartOffset;
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        this.drawGroup(canvas, paint, opacity);
    }

    Path getTextPath(Canvas canvas, Paint paint) {
        SvgView svg = this.getSvgView();
        VirtualView template = svg.getDefinedTemplate(this.mHref);
        if (!(template instanceof RenderableView)) {
            return null;
        }
        RenderableView view = (RenderableView)template;
        return view.getPath(canvas, paint);
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        return this.getGroupPath(canvas, paint);
    }

    @Override
    void pushGlyphContext() {
    }

    @Override
    void popGlyphContext() {
    }
}

