/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Region;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.FontData;
import com.horcrux.svg.GlyphContext;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.TSpanView;
import com.horcrux.svg.TextPathView;
import com.horcrux.svg.TextProperties;
import java.util.ArrayList;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class TextView
extends GroupView {
    SVGLength mInlineSize = null;
    SVGLength mTextLength = null;
    private String mBaselineShift = null;
    TextProperties.TextLengthAdjust mLengthAdjust = TextProperties.TextLengthAdjust.spacing;
    private TextProperties.AlignmentBaseline mAlignmentBaseline;
    @Nullable
    private ArrayList<SVGLength> mPositionX;
    @Nullable
    private ArrayList<SVGLength> mPositionY;
    @Nullable
    private ArrayList<SVGLength> mRotate;
    @Nullable
    private ArrayList<SVGLength> mDeltaX;
    @Nullable
    private ArrayList<SVGLength> mDeltaY;
    double cachedAdvance = Double.NaN;

    public TextView(ReactContext reactContext) {
        super(reactContext);
    }

    @Override
    public void invalidate() {
        if (this.mPath == null) {
            return;
        }
        super.invalidate();
        this.getTextContainer().clearChildCache();
    }

    @Override
    void clearCache() {
        this.cachedAdvance = Double.NaN;
        super.clearCache();
    }

    public void setInlineSize(Dynamic inlineSize) {
        this.mInlineSize = SVGLength.from(inlineSize);
        this.invalidate();
    }

    public void setTextLength(Dynamic length) {
        this.mTextLength = SVGLength.from(length);
        this.invalidate();
    }

    public void setLengthAdjust(@Nullable String adjustment) {
        this.mLengthAdjust = TextProperties.TextLengthAdjust.valueOf(adjustment);
        this.invalidate();
    }

    public void setMethod(@Nullable String alignment) {
        this.mAlignmentBaseline = TextProperties.AlignmentBaseline.getEnum(alignment);
        this.invalidate();
    }

    public void setBaselineShift(Dynamic baselineShift) {
        this.mBaselineShift = SVGLength.toString(baselineShift);
        this.invalidate();
    }

    public void setVerticalAlign(Dynamic dynamicVerticalAlign) {
        String verticalAlign = SVGLength.toString(dynamicVerticalAlign);
        if (verticalAlign != null) {
            verticalAlign = verticalAlign.trim();
            int i = verticalAlign.lastIndexOf(32);
            try {
                this.mAlignmentBaseline = TextProperties.AlignmentBaseline.getEnum(verticalAlign.substring(i));
            }
            catch (IllegalArgumentException e) {
                this.mAlignmentBaseline = TextProperties.AlignmentBaseline.baseline;
            }
            try {
                this.mBaselineShift = verticalAlign.substring(0, i);
            }
            catch (IndexOutOfBoundsException e) {
                this.mBaselineShift = null;
            }
        } else {
            this.mAlignmentBaseline = TextProperties.AlignmentBaseline.baseline;
            this.mBaselineShift = null;
        }
        this.invalidate();
    }

    public void setRotate(Dynamic rotate) {
        this.mRotate = SVGLength.arrayFrom(rotate);
        this.invalidate();
    }

    public void setDeltaX(Dynamic deltaX) {
        this.mDeltaX = SVGLength.arrayFrom(deltaX);
        this.invalidate();
    }

    public void setDeltaY(Dynamic deltaY) {
        this.mDeltaY = SVGLength.arrayFrom(deltaY);
        this.invalidate();
    }

    public void setPositionX(Dynamic positionX) {
        this.mPositionX = SVGLength.arrayFrom(positionX);
        this.invalidate();
    }

    public void setPositionY(Dynamic positionY) {
        this.mPositionY = SVGLength.arrayFrom(positionY);
        this.invalidate();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        this.setupGlyphContext(canvas);
        this.clip(canvas, paint);
        this.getGroupPath(canvas, paint);
        this.pushGlyphContext();
        this.drawGroup(canvas, paint, opacity);
        this.popGlyphContext();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        if (this.mPath != null) {
            return this.mPath;
        }
        this.setupGlyphContext(canvas);
        return this.getGroupPath(canvas, paint);
    }

    @Override
    Path getPath(Canvas canvas, Paint paint, Region.Op op) {
        return this.getPath(canvas, paint);
    }

    TextProperties.AlignmentBaseline getAlignmentBaseline() {
        if (this.mAlignmentBaseline == null) {
            for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof TextView)) continue;
                TextView node = (TextView)parent;
                TextProperties.AlignmentBaseline baseline = node.mAlignmentBaseline;
                if (baseline == null) continue;
                this.mAlignmentBaseline = baseline;
                return baseline;
            }
        }
        if (this.mAlignmentBaseline == null) {
            this.mAlignmentBaseline = TextProperties.AlignmentBaseline.baseline;
        }
        return this.mAlignmentBaseline;
    }

    String getBaselineShift() {
        if (this.mBaselineShift == null) {
            for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof TextView)) continue;
                TextView node = (TextView)parent;
                String baselineShift = node.mBaselineShift;
                if (baselineShift == null) continue;
                this.mBaselineShift = baselineShift;
                return baselineShift;
            }
        }
        return this.mBaselineShift;
    }

    Path getGroupPath(Canvas canvas, Paint paint) {
        if (this.mPath != null) {
            return this.mPath;
        }
        this.pushGlyphContext();
        this.mPath = super.getPath(canvas, paint);
        this.popGlyphContext();
        return this.mPath;
    }

    @Override
    void pushGlyphContext() {
        boolean isTextNode = !(this instanceof TextPathView) && !(this instanceof TSpanView);
        this.getTextRootGlyphContext().pushContext(isTextNode, this, this.mFont, this.mPositionX, this.mPositionY, this.mDeltaX, this.mDeltaY, this.mRotate);
    }

    TextView getTextAnchorRoot() {
        GlyphContext gc = this.getTextRootGlyphContext();
        ArrayList<FontData> font = gc.mFontContext;
        TextView node = this;
        ViewParent parent = this.getParent();
        for (int i = font.size() - 1; i >= 0; --i) {
            if (!(parent instanceof TextView) || font.get((int)i).textAnchor == TextProperties.TextAnchor.start || node.mPositionX != null) {
                return node;
            }
            node = (TextView)parent;
            parent = node.getParent();
        }
        return node;
    }

    double getSubtreeTextChunksTotalAdvance(Paint paint) {
        if (!Double.isNaN(this.cachedAdvance)) {
            return this.cachedAdvance;
        }
        double advance = 0.0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof TextView)) continue;
            TextView text = (TextView)child;
            advance += text.getSubtreeTextChunksTotalAdvance(paint);
        }
        this.cachedAdvance = advance;
        return advance;
    }

    TextView getTextContainer() {
        TextView node = this;
        ViewParent parent = this.getParent();
        while (parent instanceof TextView) {
            node = (TextView)parent;
            parent = node.getParent();
        }
        return node;
    }
}

