/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SymbolView;
import com.horcrux.svg.VirtualView;

@SuppressLint(value={"ViewConstructor"})
class UseView
extends RenderableView {
    private String mHref;
    private SVGLength mX;
    private SVGLength mY;
    private SVGLength mW;
    private SVGLength mH;

    public UseView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setHref(String href) {
        this.mHref = href;
        this.invalidate();
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        VirtualView template = this.getSvgView().getDefinedTemplate(this.mHref);
        if (template == null) {
            FLog.w((String)"ReactNative", (String)("`Use` element expected a pre-defined svg template as `href` prop, template named: " + this.mHref + " is not defined."));
            return;
        }
        template.clearCache();
        canvas.translate((float)this.relativeOnWidth(this.mX), (float)this.relativeOnHeight(this.mY));
        if (template instanceof RenderableView) {
            ((RenderableView)template).mergeProperties(this);
        }
        int count = template.saveAndSetupCanvas(canvas, this.mCTM);
        this.clip(canvas, paint);
        if (template instanceof SymbolView) {
            SymbolView symbol = (SymbolView)template;
            symbol.drawSymbol(canvas, paint, opacity, (float)this.relativeOnWidth(this.mW), (float)this.relativeOnHeight(this.mH));
        } else {
            template.draw(canvas, paint, opacity * this.mOpacity);
        }
        RectF clientRect = new RectF();
        this.getPath(canvas, paint).computeBounds(clientRect, true);
        canvas.getMatrix().mapRect(clientRect);
        this.setClientRect(clientRect);
        template.restoreCanvas(canvas, count);
        if (template instanceof RenderableView) {
            ((RenderableView)template).resetProperties();
        }
    }

    @Override
    int hitTest(float[] src) {
        if (!this.mInvertible) {
            return -1;
        }
        float[] dst = new float[2];
        this.mInvMatrix.mapPoints(dst, src);
        this.mInvTransform.mapPoints(dst);
        VirtualView template = this.getSvgView().getDefinedTemplate(this.mHref);
        if (template == null) {
            FLog.w((String)"ReactNative", (String)("`Use` element expected a pre-defined svg template as `href` prop, template named: " + this.mHref + " is not defined."));
            return -1;
        }
        int hitChild = template.hitTest(dst);
        if (hitChild != -1) {
            return template.isResponsible() || hitChild != template.getId() ? hitChild : this.getId();
        }
        return -1;
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        VirtualView template = this.getSvgView().getDefinedTemplate(this.mHref);
        if (template == null) {
            FLog.w((String)"ReactNative", (String)("`Use` element expected a pre-defined svg template as `href` prop, template named: " + this.mHref + " is not defined."));
            return null;
        }
        Path path = template.getPath(canvas, paint);
        Path use = new Path();
        Matrix m = new Matrix();
        m.setTranslate((float)this.relativeOnWidth(this.mX), (float)this.relativeOnHeight(this.mY));
        path.transform(m, use);
        return use;
    }
}

