/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Matrix;
import android.graphics.RectF;

class ViewBox {
    private static final int MOS_MEET = 0;
    private static final int MOS_SLICE = 1;
    private static final int MOS_NONE = 2;

    ViewBox() {
    }

    static Matrix getTransform(RectF vbRect, RectF eRect, String align, int meetOrSlice) {
        double vbX = vbRect.left;
        double vbY = vbRect.top;
        double vbWidth = vbRect.width();
        double vbHeight = vbRect.height();
        double eX = eRect.left;
        double eY = eRect.top;
        double eWidth = eRect.width();
        double eHeight = eRect.height();
        double scaleX = eWidth / vbWidth;
        double scaleY = eHeight / vbHeight;
        double translateX = eX - vbX * scaleX;
        double translateY = eY - vbY * scaleY;
        if (meetOrSlice == 2) {
            scaleX = scaleY = Math.min(scaleX, scaleY);
            double scale = scaleY;
            if (scale > 1.0) {
                translateX -= (eWidth / scale - vbWidth) / 2.0;
                translateY -= (eHeight / scale - vbHeight) / 2.0;
            } else {
                translateX -= (eWidth - vbWidth * scale) / 2.0;
                translateY -= (eHeight - vbHeight * scale) / 2.0;
            }
        } else {
            if (!align.equals("none") && meetOrSlice == 0) {
                scaleX = scaleY = Math.min(scaleX, scaleY);
            } else if (!align.equals("none") && meetOrSlice == 1) {
                scaleX = scaleY = Math.max(scaleX, scaleY);
            }
            if (align.contains("xMid")) {
                translateX += (eWidth - vbWidth * scaleX) / 2.0;
            }
            if (align.contains("xMax")) {
                translateX += eWidth - vbWidth * scaleX;
            }
            if (align.contains("YMid")) {
                translateY += (eHeight - vbHeight * scaleY) / 2.0;
            }
            if (align.contains("YMax")) {
                translateY += eHeight - vbHeight * scaleY;
            }
        }
        Matrix transform = new Matrix();
        transform.postTranslate((float)translateX, (float)translateY);
        transform.preScale((float)scaleX, (float)scaleY);
        return transform;
    }
}

