/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Matrix;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.MatrixMathHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.TransformHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.horcrux.svg.CircleView;
import com.horcrux.svg.ClipPathView;
import com.horcrux.svg.DefsView;
import com.horcrux.svg.EllipseView;
import com.horcrux.svg.FeBlendView;
import com.horcrux.svg.FeColorMatrixView;
import com.horcrux.svg.FeCompositeView;
import com.horcrux.svg.FeFloodView;
import com.horcrux.svg.FeGaussianBlurView;
import com.horcrux.svg.FeMergeView;
import com.horcrux.svg.FeOffsetView;
import com.horcrux.svg.FilterView;
import com.horcrux.svg.ForeignObjectView;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.ImageView;
import com.horcrux.svg.LineView;
import com.horcrux.svg.LinearGradientView;
import com.horcrux.svg.MarkerView;
import com.horcrux.svg.MaskView;
import com.horcrux.svg.PathView;
import com.horcrux.svg.PatternView;
import com.horcrux.svg.RadialGradientView;
import com.horcrux.svg.RectView;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.SymbolView;
import com.horcrux.svg.TSpanView;
import com.horcrux.svg.TextPathView;
import com.horcrux.svg.TextView;
import com.horcrux.svg.UseView;
import com.horcrux.svg.VirtualView;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class VirtualViewManager<V extends VirtualView>
extends ViewGroupManager<VirtualView> {
    protected final SVGClass svgClass;
    protected final String mClassName;
    protected ViewManagerDelegate<V> mDelegate;
    private static final MatrixMathHelper.MatrixDecompositionContext sMatrixDecompositionContext = new MatrixMathHelper.MatrixDecompositionContext();
    private static final double[] sTransformDecompositionArray = new double[16];
    private static final int PERSPECTIVE_ARRAY_INVERTED_CAMERA_DISTANCE_INDEX = 2;
    private static final float CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER = 5.0f;
    private static final SparseArray<RenderableView> mTagToRenderableView = new SparseArray();
    private static final SparseArray<Runnable> mTagToRunnable = new SparseArray();

    protected VirtualViewManager(SVGClass svgclass) {
        this.svgClass = svgclass;
        this.mClassName = svgclass.toString();
    }

    protected ViewManagerDelegate getDelegate() {
        return this.mDelegate;
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new RenderableShadowNode();
    }

    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return RenderableShadowNode.class;
    }

    private static float sanitizeFloatPropertyValue(float value) {
        if (value >= -3.4028235E38f && value <= Float.MAX_VALUE) {
            return value;
        }
        if (value < -3.4028235E38f || value == Float.NEGATIVE_INFINITY) {
            return -3.4028235E38f;
        }
        if (value > Float.MAX_VALUE || value == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        throw new IllegalStateException("Invalid float property value: " + value);
    }

    protected void setTransformProperty(VirtualView view, ReadableArray transforms) {
        if (transforms == null) {
            view.setTranslationX(PixelUtil.toPixelFromDIP((float)0.0f));
            view.setTranslationY(PixelUtil.toPixelFromDIP((float)0.0f));
            view.setRotation(0.0f);
            view.setRotationX(0.0f);
            view.setRotationY(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
            view.setCameraDistance(0.0f);
            return;
        }
        sMatrixDecompositionContext.reset();
        TransformHelper.processTransform((ReadableArray)transforms, (double[])sTransformDecompositionArray, (float)view.getWidth(), (float)view.getHeight(), null, (boolean)false);
        MatrixMathHelper.decomposeMatrix((double[])sTransformDecompositionArray, (MatrixMathHelper.MatrixDecompositionContext)sMatrixDecompositionContext);
        view.setTranslationX(PixelUtil.toPixelFromDIP((float)VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.translation[0])));
        view.setTranslationY(PixelUtil.toPixelFromDIP((float)VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.translation[1])));
        view.setRotation(VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.rotationDegrees[2]));
        view.setRotationX(VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.rotationDegrees[0]));
        view.setRotationY(VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.rotationDegrees[1]));
        view.setScaleX(VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.scale[0]));
        view.setScaleY(VirtualViewManager.sanitizeFloatPropertyValue((float)VirtualViewManager.sMatrixDecompositionContext.scale[1]));
        double[] perspectiveArray = VirtualViewManager.sMatrixDecompositionContext.perspective;
        if (perspectiveArray.length > 2) {
            float invertedCameraDistance = (float)perspectiveArray[2];
            if (invertedCameraDistance == 0.0f) {
                invertedCameraDistance = 7.8125E-4f;
            }
            float cameraDistance = -1.0f / invertedCameraDistance;
            float scale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
            float normalizedCameraDistance = scale * scale * cameraDistance * 5.0f;
            view.setCameraDistance(normalizedCameraDistance);
        }
    }

    @Nonnull
    public String getName() {
        return this.mClassName;
    }

    @ReactProp(name="mask")
    public void setMask(V node, String mask) {
        ((VirtualView)((Object)node)).setMask(mask);
    }

    @ReactProp(name="markerStart")
    public void setMarkerStart(V node, String markerStart) {
        ((VirtualView)((Object)node)).setMarkerStart(markerStart);
    }

    @ReactProp(name="markerMid")
    public void setMarkerMid(V node, String markerMid) {
        ((VirtualView)((Object)node)).setMarkerMid(markerMid);
    }

    @ReactProp(name="markerEnd")
    public void setMarkerEnd(V node, String markerEnd) {
        ((VirtualView)((Object)node)).setMarkerEnd(markerEnd);
    }

    @ReactProp(name="clipPath")
    public void setClipPath(V node, String clipPath) {
        ((VirtualView)((Object)node)).setClipPath(clipPath);
    }

    @ReactProp(name="clipRule")
    public void setClipRule(V node, int clipRule) {
        ((VirtualView)((Object)node)).setClipRule(clipRule);
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(@Nonnull V node, float opacity) {
        ((VirtualView)((Object)node)).setOpacity(opacity);
    }

    @ReactProp(name="responsible")
    public void setResponsible(V node, boolean responsible) {
        ((VirtualView)((Object)node)).setResponsible(responsible);
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(V view, @Nullable String pointerEventsStr) {
        if (pointerEventsStr == null) {
            ((VirtualView)((Object)view)).setPointerEvents(PointerEvents.AUTO);
        } else {
            PointerEvents pointerEvents = PointerEvents.valueOf((String)pointerEventsStr.toUpperCase(Locale.US).replace("-", "_"));
            ((VirtualView)((Object)view)).setPointerEvents(pointerEvents);
        }
    }

    @ReactProp(name="name")
    public void setName(V node, String name) {
        ((VirtualView)((Object)node)).setName(name);
    }

    @ReactProp(name="display")
    public void setDisplay(V node, String display) {
        ((VirtualView)((Object)node)).setDisplay(display);
    }

    @ReactProp(name="matrix")
    public void setMatrix(V node, Dynamic matrixArray) {
        ((VirtualView)((Object)node)).setMatrix(matrixArray);
    }

    public void setMatrix(V view, @Nullable ReadableArray value) {
        ((VirtualView)((Object)view)).setMatrix(value);
    }

    public void setTransform(VirtualView node, @Nullable ReadableArray matrix) {
        Matrix m;
        this.setTransformProperty(node, matrix);
        node.mMatrix = m = node.getMatrix();
        node.mInvertible = m.invert(node.mInvMatrix);
    }

    @ReactProp(name="transform")
    public void setTransform(V node, Dynamic matrix) {
        if (matrix.getType() != ReadableType.Array) {
            return;
        }
        ReadableArray ma = matrix.asArray();
        this.setTransform((VirtualView)((Object)node), ma);
    }

    private void invalidateSvgView(V node) {
        SvgView view = ((VirtualView)((Object)node)).getSvgView();
        if (view != null) {
            view.invalidate();
        }
        if (node instanceof TextView) {
            ((TextView)((Object)node)).getTextContainer().clearChildCache();
        }
    }

    protected void addEventEmitters(@Nonnull ThemedReactContext reactContext, @Nonnull VirtualView view) {
        super.addEventEmitters(reactContext, (View)view);
        view.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View view, View view1) {
                if (view instanceof VirtualView) {
                    VirtualViewManager.this.invalidateSvgView((VirtualView)view);
                }
            }

            public void onChildViewRemoved(View view, View view1) {
                if (view instanceof VirtualView) {
                    VirtualViewManager.this.invalidateSvgView((VirtualView)view);
                }
            }
        });
    }

    protected void onAfterUpdateTransaction(@Nonnull VirtualView node) {
        super.onAfterUpdateTransaction((View)node);
        this.invalidateSvgView(node);
    }

    @Nonnull
    protected VirtualView createViewInstance(@Nonnull ThemedReactContext reactContext) {
        switch (this.svgClass) {
            case RNSVGGroup: {
                return new GroupView((ReactContext)reactContext);
            }
            case RNSVGPath: {
                return new PathView((ReactContext)reactContext);
            }
            case RNSVGCircle: {
                return new CircleView((ReactContext)reactContext);
            }
            case RNSVGEllipse: {
                return new EllipseView((ReactContext)reactContext);
            }
            case RNSVGLine: {
                return new LineView((ReactContext)reactContext);
            }
            case RNSVGRect: {
                return new RectView((ReactContext)reactContext);
            }
            case RNSVGText: {
                return new TextView((ReactContext)reactContext);
            }
            case RNSVGTSpan: {
                return new TSpanView((ReactContext)reactContext);
            }
            case RNSVGTextPath: {
                return new TextPathView((ReactContext)reactContext);
            }
            case RNSVGImage: {
                return new ImageView((ReactContext)reactContext);
            }
            case RNSVGClipPath: {
                return new ClipPathView((ReactContext)reactContext);
            }
            case RNSVGDefs: {
                return new DefsView((ReactContext)reactContext);
            }
            case RNSVGUse: {
                return new UseView((ReactContext)reactContext);
            }
            case RNSVGSymbol: {
                return new SymbolView((ReactContext)reactContext);
            }
            case RNSVGLinearGradient: {
                return new LinearGradientView((ReactContext)reactContext);
            }
            case RNSVGRadialGradient: {
                return new RadialGradientView((ReactContext)reactContext);
            }
            case RNSVGPattern: {
                return new PatternView((ReactContext)reactContext);
            }
            case RNSVGMask: {
                return new MaskView((ReactContext)reactContext);
            }
            case RNSVGFilter: {
                return new FilterView((ReactContext)reactContext);
            }
            case RNSVGFeBlend: {
                return new FeBlendView((ReactContext)reactContext);
            }
            case RNSVGFeColorMatrix: {
                return new FeColorMatrixView((ReactContext)reactContext);
            }
            case RNSVGFeComposite: {
                return new FeCompositeView((ReactContext)reactContext);
            }
            case RNSVGFeFlood: {
                return new FeFloodView((ReactContext)reactContext);
            }
            case RNSVGFeGaussianBlur: {
                return new FeGaussianBlurView((ReactContext)reactContext);
            }
            case RNSVGFeMerge: {
                return new FeMergeView((ReactContext)reactContext);
            }
            case RNSVGFeOffset: {
                return new FeOffsetView((ReactContext)reactContext);
            }
            case RNSVGMarker: {
                return new MarkerView((ReactContext)reactContext);
            }
            case RNSVGForeignObject: {
                return new ForeignObjectView((ReactContext)reactContext);
            }
        }
        throw new IllegalStateException("Unexpected type " + this.svgClass.toString());
    }

    static void setRenderableView(int tag, RenderableView svg) {
        mTagToRenderableView.put(tag, (Object)svg);
        Runnable task = (Runnable)mTagToRunnable.get(tag);
        if (task != null) {
            task.run();
            mTagToRunnable.delete(tag);
        }
    }

    static void runWhenViewIsAvailable(int tag, Runnable task) {
        mTagToRunnable.put(tag, (Object)task);
    }

    @Nullable
    static RenderableView getRenderableViewByTag(int tag) {
        return (RenderableView)((Object)mTagToRenderableView.get(tag));
    }

    public void onDropViewInstance(@Nonnull VirtualView view) {
        super.onDropViewInstance((View)view);
        mTagToRenderableView.remove(view.getId());
    }

    protected static enum SVGClass {
        RNSVGGroup,
        RNSVGPath,
        RNSVGText,
        RNSVGTSpan,
        RNSVGTextPath,
        RNSVGImage,
        RNSVGCircle,
        RNSVGEllipse,
        RNSVGLine,
        RNSVGRect,
        RNSVGClipPath,
        RNSVGDefs,
        RNSVGUse,
        RNSVGSymbol,
        RNSVGLinearGradient,
        RNSVGRadialGradient,
        RNSVGPattern,
        RNSVGMask,
        RNSVGFilter,
        RNSVGFeBlend,
        RNSVGFeColorMatrix,
        RNSVGFeComposite,
        RNSVGFeFlood,
        RNSVGFeGaussianBlur,
        RNSVGFeMerge,
        RNSVGFeOffset,
        RNSVGMarker,
        RNSVGForeignObject;

    }

    static class RenderableShadowNode
    extends LayoutShadowNode {
        RenderableShadowNode() {
        }

        @ReactPropGroup(names={"alignSelf", "alignItems", "collapsable", "flex", "flexBasis", "flexDirection", "flexGrow", "flexShrink", "flexWrap", "justifyContent", "overflow", "alignContent", "display", "position", "right", "top", "bottom", "left", "start", "end", "width", "height", "minWidth", "maxWidth", "minHeight", "maxHeight", "margin", "marginVertical", "marginHorizontal", "marginLeft", "marginRight", "marginTop", "marginBottom", "marginStart", "marginEnd", "padding", "paddingVertical", "paddingHorizontal", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom", "paddingStart", "paddingEnd", "borderWidth", "borderStartWidth", "borderEndWidth", "borderTopWidth", "borderBottomWidth", "borderLeftWidth", "borderRightWidth"})
        public void ignoreLayoutProps(int index, Dynamic value) {
        }
    }
}

