/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableArray;
import com.horcrux.svg.PatternView;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.ViewBox;

class Brush {
    private final BrushType mType;
    private final SVGLength[] mPoints;
    private ReadableArray mColors;
    private final boolean mUseObjectBoundingBox;
    private boolean mUseContentObjectBoundingBoxUnits;
    private Matrix mMatrix;
    private Rect mUserSpaceBoundingBox;
    private PatternView mPattern;

    Brush(BrushType type, SVGLength[] points, BrushUnits units) {
        this.mType = type;
        this.mPoints = points;
        this.mUseObjectBoundingBox = units == BrushUnits.OBJECT_BOUNDING_BOX;
    }

    void setContentUnits(BrushUnits units) {
        this.mUseContentObjectBoundingBoxUnits = units == BrushUnits.OBJECT_BOUNDING_BOX;
    }

    void setPattern(PatternView pattern) {
        this.mPattern = pattern;
    }

    private static void parseGradientStops(ReadableArray value, int stopsCount, float[] stops, int[] stopsColors, float opacity) {
        for (int i = 0; i < stopsCount; ++i) {
            int stopIndex = i * 2;
            stops[i] = (float)value.getDouble(stopIndex);
            int color = value.getInt(stopIndex + 1);
            int alpha = color >>> 24;
            int combined = Math.round((float)alpha * opacity);
            stopsColors[i] = combined << 24 | color & 0xFFFFFF;
        }
    }

    void setUserSpaceBoundingBox(Rect userSpaceBoundingBox) {
        this.mUserSpaceBoundingBox = userSpaceBoundingBox;
    }

    void setGradientColors(ReadableArray colors) {
        this.mColors = colors;
    }

    void setGradientTransform(Matrix matrix) {
        this.mMatrix = matrix;
    }

    private RectF getPaintRect(RectF pathBoundingBox) {
        RectF rect = this.mUseObjectBoundingBox ? pathBoundingBox : new RectF(this.mUserSpaceBoundingBox);
        float width = rect.width();
        float height = rect.height();
        float x = 0.0f;
        float y = 0.0f;
        if (this.mUseObjectBoundingBox) {
            x = rect.left;
            y = rect.top;
        }
        return new RectF(x, y, x + width, y + height);
    }

    private double getVal(SVGLength length, double relative, float scale, float textSize) {
        return PropHelper.fromRelative(length, relative, 0.0, this.mUseObjectBoundingBox && length.unit == SVGLength.UnitType.NUMBER ? relative : (double)scale, textSize);
    }

    void setupPaint(Paint paint, RectF pathBoundingBox, float scale, float opacity) {
        RectF rect = this.getPaintRect(pathBoundingBox);
        float width = rect.width();
        float height = rect.height();
        float offsetX = rect.left;
        float offsetY = rect.top;
        float textSize = paint.getTextSize();
        if (this.mType == BrushType.PATTERN) {
            double x = this.getVal(this.mPoints[0], width, scale, textSize);
            double y = this.getVal(this.mPoints[1], height, scale, textSize);
            double w = this.getVal(this.mPoints[2], width, scale, textSize);
            double h = this.getVal(this.mPoints[3], height, scale, textSize);
            if (!(w > 1.0) || !(h > 1.0)) {
                return;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)((int)w), (int)((int)h), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            RectF vbRect = this.mPattern.getViewBox();
            if (vbRect != null && vbRect.width() > 0.0f && vbRect.height() > 0.0f) {
                RectF eRect = new RectF((float)x, (float)y, (float)w, (float)h);
                Matrix mViewBoxMatrix = ViewBox.getTransform(vbRect, eRect, this.mPattern.mAlign, this.mPattern.mMeetOrSlice);
                canvas.concat(mViewBoxMatrix);
            }
            if (this.mUseContentObjectBoundingBoxUnits) {
                canvas.scale(width / scale, height / scale);
            }
            this.mPattern.draw(canvas, new Paint(), opacity);
            Matrix patternMatrix = new Matrix();
            if (this.mMatrix != null) {
                patternMatrix.preConcat(this.mMatrix);
            }
            BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            bitmapShader.setLocalMatrix(patternMatrix);
            paint.setShader((Shader)bitmapShader);
            return;
        }
        int size = this.mColors.size();
        if (size == 0) {
            FLog.w((String)"ReactNative", (String)"Gradient contains no stops");
            return;
        }
        int stopsCount = size / 2;
        int[] stopsColors = new int[stopsCount];
        float[] stops = new float[stopsCount];
        Brush.parseGradientStops(this.mColors, stopsCount, stops, stopsColors, opacity);
        if (stops.length == 1) {
            stopsColors = new int[]{stopsColors[0], stopsColors[0]};
            stops = new float[]{stops[0], stops[0]};
            FLog.w((String)"ReactNative", (String)"Gradient contains only one stop");
        }
        if (this.mType == BrushType.LINEAR_GRADIENT) {
            double x1 = this.getVal(this.mPoints[0], width, scale, textSize) + (double)offsetX;
            double y1 = this.getVal(this.mPoints[1], height, scale, textSize) + (double)offsetY;
            double x2 = this.getVal(this.mPoints[2], width, scale, textSize) + (double)offsetX;
            double y2 = this.getVal(this.mPoints[3], height, scale, textSize) + (double)offsetY;
            LinearGradient linearGradient = new LinearGradient((float)x1, (float)y1, (float)x2, (float)y2, stopsColors, stops, Shader.TileMode.CLAMP);
            if (this.mMatrix != null) {
                Matrix m = new Matrix();
                m.preConcat(this.mMatrix);
                linearGradient.setLocalMatrix(m);
            }
            paint.setShader((Shader)linearGradient);
        } else if (this.mType == BrushType.RADIAL_GRADIENT) {
            double rx = this.getVal(this.mPoints[2], width, scale, textSize);
            double ry = this.getVal(this.mPoints[3], height, scale, textSize);
            if (rx <= 0.0 || ry <= 0.0) {
                rx = width;
                ry = height;
                stops = new float[]{stops[0], stops[stops.length - 1]};
                stopsColors = new int[]{stopsColors[stopsColors.length - 1], stopsColors[stopsColors.length - 1]};
            }
            double ratio = ry / rx;
            double cx = this.getVal(this.mPoints[4], width, scale, textSize) + (double)offsetX;
            double cy = this.getVal(this.mPoints[5], (double)height / ratio, scale, textSize) + (double)offsetY / ratio;
            RadialGradient radialGradient = new RadialGradient((float)cx, (float)cy, (float)rx, stopsColors, stops, Shader.TileMode.CLAMP);
            Matrix radialMatrix = new Matrix();
            radialMatrix.preScale(1.0f, (float)ratio);
            if (this.mMatrix != null) {
                radialMatrix.preConcat(this.mMatrix);
            }
            radialGradient.setLocalMatrix(radialMatrix);
            paint.setShader((Shader)radialGradient);
        }
    }

    static enum BrushType {
        LINEAR_GRADIENT,
        RADIAL_GRADIENT,
        PATTERN;

    }

    static enum BrushUnits {
        OBJECT_BOUNDING_BOX,
        USER_SPACE_ON_USE;

    }
}

