/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
class CircleView
extends RenderableView {
    private SVGLength mCx;
    private SVGLength mCy;
    private SVGLength mR;

    public CircleView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setCx(Dynamic cx) {
        this.mCx = SVGLength.from(cx);
        this.invalidate();
    }

    public void setCy(Dynamic cy) {
        this.mCy = SVGLength.from(cy);
        this.invalidate();
    }

    public void setR(Dynamic r) {
        this.mR = SVGLength.from(r);
        this.invalidate();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        Path path = new Path();
        double cx = this.relativeOnWidth(this.mCx);
        double cy = this.relativeOnHeight(this.mCy);
        double r = this.relativeOnOther(this.mR);
        path.addCircle((float)cx, (float)cy, (float)r, Path.Direction.CW);
        this.elements = new ArrayList();
        this.elements.add(new PathElement(ElementType.kCGPathElementMoveToPoint, new Point[]{new Point(cx, cy - r)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx, cy - r), new Point(cx + r, cy)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx + r, cy), new Point(cx, cy + r)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx, cy + r), new Point(cx - r, cy)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx - r, cy), new Point(cx, cy - r)}));
        return path;
    }
}

