/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Bitmap;
import com.horcrux.svg.CustomFilterFunction;

public class CustomFilter {
    public static Bitmap apply(Bitmap srcBmp, Bitmap dstBmp, CustomFilterFunction func) {
        int width = srcBmp.getWidth();
        int height = srcBmp.getHeight();
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        int[] resPixels = new int[width * height];
        int srcArgb = 0;
        float[] src = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int dstArgb = 0;
        float[] dst = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        try {
            srcBmp.getPixels(srcPixels, 0, width, 0, 0, width, height);
            dstBmp.getPixels(dstPixels, 0, width, 0, 0, width, height);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
            // empty catch block
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                srcArgb = srcPixels[y * width + x];
                src[0] = (float)(srcArgb >> 24 & 0xFF) / 255.0f;
                src[1] = (float)(srcArgb >> 16 & 0xFF) / 255.0f;
                src[2] = (float)(srcArgb >> 8 & 0xFF) / 255.0f;
                src[3] = (float)(srcArgb & 0xFF) / 255.0f;
                dstArgb = dstPixels[y * width + x];
                dst[0] = (float)(dstArgb >> 24 & 0xFF) / 255.0f;
                dst[1] = (float)(dstArgb >> 16 & 0xFF) / 255.0f;
                dst[2] = (float)(dstArgb >> 8 & 0xFF) / 255.0f;
                dst[3] = (float)(dstArgb & 0xFF) / 255.0f;
                resPixels[y * width + x] = CustomFilter.normalizeFromFloats(func.execute(src, dst));
            }
        }
        return Bitmap.createBitmap((int[])resPixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static int normalizeFromFloat(float c) {
        return Math.min(255, Math.max(0, Math.round(c * 255.0f)));
    }

    public static int normalizeFromFloats(float[] res) {
        if (res.length < 4 || CustomFilter.normalizeFromFloat(res[0]) <= 0) {
            return 0;
        }
        return CustomFilter.normalizeFromFloat(res[0]) << 24 | CustomFilter.normalizeFromFloat(res[1] / res[0]) << 16 | CustomFilter.normalizeFromFloat(res[2] / res[0]) << 8 | CustomFilter.normalizeFromFloat(res[3] / res[0]);
    }
}

