/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
class EllipseView
extends RenderableView {
    private SVGLength mCx;
    private SVGLength mCy;
    private SVGLength mRx;
    private SVGLength mRy;

    public EllipseView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setCx(Dynamic cx) {
        this.mCx = SVGLength.from(cx);
        this.invalidate();
    }

    public void setCy(Dynamic cy) {
        this.mCy = SVGLength.from(cy);
        this.invalidate();
    }

    public void setRx(Dynamic rx) {
        this.mRx = SVGLength.from(rx);
        this.invalidate();
    }

    public void setRy(Dynamic ry) {
        this.mRy = SVGLength.from(ry);
        this.invalidate();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        Path path = new Path();
        double cx = this.relativeOnWidth(this.mCx);
        double cy = this.relativeOnHeight(this.mCy);
        double rx = this.relativeOnWidth(this.mRx);
        double ry = this.relativeOnHeight(this.mRy);
        RectF oval = new RectF((float)(cx - rx), (float)(cy - ry), (float)(cx + rx), (float)(cy + ry));
        path.addOval(oval, Path.Direction.CW);
        this.elements = new ArrayList();
        this.elements.add(new PathElement(ElementType.kCGPathElementMoveToPoint, new Point[]{new Point(cx, cy - ry)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx, cy - ry), new Point(cx + rx, cy)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx + rx, cy), new Point(cx, cy + ry)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx, cy + ry), new Point(cx - rx, cy)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(cx - rx, cy), new Point(cx, cy - ry)}));
        return path;
    }
}

