/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.FilterPrimitiveView;
import com.horcrux.svg.FilterProperties;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class FeCompositeView
extends FilterPrimitiveView {
    String mIn1;
    String mIn2;
    float mK1;
    float mK2;
    float mK3;
    float mK4;
    FilterProperties.FeCompositeOperator mOperator;

    public FeCompositeView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setIn1(String in1) {
        this.mIn1 = in1;
        this.invalidate();
    }

    public void setIn2(String in2) {
        this.mIn2 = in2;
        this.invalidate();
    }

    public void setK1(Float value) {
        this.mK1 = value.floatValue();
        this.invalidate();
    }

    public void setK2(Float value) {
        this.mK2 = value.floatValue();
        this.invalidate();
    }

    public void setK3(Float value) {
        this.mK3 = value.floatValue();
        this.invalidate();
    }

    public void setK4(Float value) {
        this.mK4 = value.floatValue();
        this.invalidate();
    }

    public void setOperator(String operator) {
        this.mOperator = FilterProperties.FeCompositeOperator.getEnum(operator);
        this.invalidate();
    }

    @Override
    public Bitmap applyFilter(HashMap<String, Bitmap> resultsMap, Bitmap prevResult) {
        Bitmap in1 = FeCompositeView.getSource(resultsMap, prevResult, this.mIn1);
        Bitmap in2 = FeCompositeView.getSource(resultsMap, prevResult, this.mIn2);
        Bitmap result = Bitmap.createBitmap((int)in1.getWidth(), (int)in1.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint(1);
        canvas.drawBitmap(in1, 0.0f, 0.0f, paint);
        switch (this.mOperator) {
            case OVER: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OVER));
                break;
            }
            case IN: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                break;
            }
            case OUT: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
                break;
            }
            case ATOP: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                break;
            }
            case XOR: {
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.XOR));
                break;
            }
            case ARITHMETIC: {
                int nPixels = result.getWidth() * result.getHeight();
                int[] pixels1 = new int[nPixels];
                int[] pixels2 = new int[nPixels];
                result.getPixels(pixels1, 0, result.getWidth(), 0, 0, result.getWidth(), result.getHeight());
                in2.getPixels(pixels2, 0, result.getWidth(), 0, 0, result.getWidth(), result.getHeight());
                for (int i = 0; i < nPixels; ++i) {
                    int pixel;
                    int color1 = pixels1[i];
                    int color2 = pixels2[i];
                    int r1 = color1 >> 16 & 0xFF;
                    int g1 = color1 >> 8 & 0xFF;
                    int b1 = color1 & 0xFF;
                    int a1 = color1 >>> 24;
                    int r2 = color2 >> 16 & 0xFF;
                    int g2 = color2 >> 8 & 0xFF;
                    int b2 = color2 & 0xFF;
                    int a2 = color2 >>> 24;
                    int rResult = (int)(this.mK1 * (float)r1 * (float)r2 + this.mK2 * (float)r1 + this.mK3 * (float)r2 + this.mK4);
                    int gResult = (int)(this.mK1 * (float)g1 * (float)g2 + this.mK2 * (float)g1 + this.mK3 * (float)g2 + this.mK4);
                    int bResult = (int)(this.mK1 * (float)b1 * (float)b2 + this.mK2 * (float)b1 + this.mK3 * (float)b2 + this.mK4);
                    int aResult = (int)(this.mK1 * (float)a1 * (float)a2 + this.mK2 * (float)a1 + this.mK3 * (float)a2 + this.mK4);
                    rResult = Math.min(255, Math.max(0, rResult));
                    gResult = Math.min(255, Math.max(0, gResult));
                    bResult = Math.min(255, Math.max(0, bResult));
                    aResult = Math.min(255, Math.max(0, aResult));
                    pixels1[i] = pixel = aResult << 24 | rResult << 16 | gResult << 8 | bResult;
                }
                result.setPixels(pixels1, 0, result.getWidth(), 0, 0, result.getWidth(), result.getHeight());
            }
        }
        if (this.mOperator != FilterProperties.FeCompositeOperator.ARITHMETIC) {
            canvas.drawBitmap(in2, 0.0f, 0.0f, paint);
        }
        return result;
    }
}

