/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.horcrux.svg.FilterPrimitiveView;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class FeFloodView
extends FilterPrimitiveView {
    private static final Pattern regex = Pattern.compile("[0-9.-]+");
    @Nullable
    public ReadableArray floodColor;
    public float floodOpacity = 1.0f;

    public FeFloodView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setFloodColor(@Nullable Dynamic color) {
        if (color == null || color.isNull()) {
            this.floodColor = null;
            this.invalidate();
            return;
        }
        ReadableType strokeType = color.getType();
        if (strokeType.equals((Object)ReadableType.Map)) {
            ReadableMap colorMap = color.asMap();
            this.setFloodColor(colorMap);
            return;
        }
        ReadableType type = color.getType();
        if (type.equals((Object)ReadableType.Number)) {
            this.floodColor = JavaOnlyArray.of((Object[])new Object[]{0, color.asInt()});
        } else if (type.equals((Object)ReadableType.Array)) {
            this.floodColor = color.asArray();
        } else {
            JavaOnlyArray arr = new JavaOnlyArray();
            arr.pushInt(0);
            Matcher m = regex.matcher(color.asString());
            int i = 0;
            while (m.find()) {
                double parsed = Double.parseDouble(m.group());
                arr.pushDouble(i++ < 3 ? parsed / 255.0 : parsed);
            }
            this.floodColor = arr;
        }
        this.invalidate();
    }

    public void setFloodColor(@Nullable ReadableMap color) {
        if (color == null) {
            this.floodColor = null;
            this.invalidate();
            return;
        }
        int type = color.getInt("type");
        if (type == 0) {
            ReadableType payloadType = color.getType("payload");
            if (payloadType.equals((Object)ReadableType.Number)) {
                this.floodColor = JavaOnlyArray.of((Object[])new Object[]{0, color.getInt("payload")});
            } else if (payloadType.equals((Object)ReadableType.Map)) {
                this.floodColor = JavaOnlyArray.of((Object[])new Object[]{0, color.getMap("payload")});
            }
        } else {
            this.floodColor = type == 1 ? JavaOnlyArray.of((Object[])new Object[]{1, color.getString("brushRef")}) : JavaOnlyArray.of((Object[])new Object[]{type});
        }
        this.invalidate();
    }

    public void setFloodOpacity(float opacity) {
        this.floodOpacity = opacity;
        this.invalidate();
    }

    @Override
    public Bitmap applyFilter(HashMap<String, Bitmap> resultsMap, Bitmap prevResult) {
        Bitmap floodBitmap = Bitmap.createBitmap((int)prevResult.getWidth(), (int)prevResult.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas floodCanvas = new Canvas(floodBitmap);
        Paint paint = new Paint();
        paint.setFlags(129);
        paint.setStyle(Paint.Style.FILL);
        this.setupPaint(paint, this.floodOpacity, this.floodColor);
        floodCanvas.drawPaint(paint);
        return floodBitmap;
    }

    private void setupPaint(Paint paint, float opacity, @Nullable ReadableArray colors) {
        int colorType = colors.getInt(0);
        switch (colorType) {
            case 0: {
                if (colors.size() == 2) {
                    int color = colors.getType(1) == ReadableType.Map ? ColorPropConverter.getColor((Object)colors.getMap(1), (Context)this.getContext()).intValue() : colors.getInt(1);
                    int alpha = color >>> 24;
                    int combined = Math.round((float)alpha * opacity);
                    paint.setColor(combined << 24 | color & 0xFFFFFF);
                    break;
                }
                paint.setARGB((int)(colors.size() > 4 ? colors.getDouble(4) * (double)opacity * 255.0 : (double)(opacity * 255.0f)), (int)(colors.getDouble(1) * 255.0), (int)(colors.getDouble(2) * 255.0), (int)(colors.getDouble(3) * 255.0));
            }
        }
    }
}

