/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.FilterPrimitiveView;
import com.horcrux.svg.FilterProperties;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class FeGaussianBlurView
extends FilterPrimitiveView {
    String mIn1;
    float mStdDeviationX;
    float mStdDeviationY;
    FilterProperties.EdgeMode mEdgeMode;

    public FeGaussianBlurView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setIn1(String in1) {
        this.mIn1 = in1;
        this.invalidate();
    }

    public void setStdDeviationX(float stdDeviationX) {
        this.mStdDeviationX = stdDeviationX;
        this.invalidate();
    }

    public void setStdDeviationY(float stdDeviationY) {
        this.mStdDeviationY = stdDeviationY;
        this.invalidate();
    }

    public void setEdgeMode(String edgeMode) {
        this.mEdgeMode = FilterProperties.EdgeMode.getEnum(edgeMode);
        this.invalidate();
    }

    @Override
    public Bitmap applyFilter(HashMap<String, Bitmap> resultsMap, Bitmap prevResult) {
        Bitmap source = FeGaussianBlurView.getSource(resultsMap, prevResult, this.mIn1);
        return this.blur(this.getContext(), source);
    }

    private Bitmap blur(Context context, Bitmap bitmap) {
        float stdDeviation = Math.max(this.mStdDeviationX, this.mStdDeviationY) * 2.0f;
        if (stdDeviation <= 0.0f) {
            return bitmap;
        }
        float maxRadius = 25.0f;
        float radius = Math.min(stdDeviation, 25.0f);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)bitmap);
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        blurScript.setRadius(radius);
        blurScript.setInput(tmpIn);
        blurScript.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        tmpIn.destroy();
        tmpOut.destroy();
        rs.destroy();
        return Bitmap.createScaledBitmap((Bitmap)outputBitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
    }
}

