/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Rect;
import android.graphics.RectF;
import com.facebook.react.bridge.Dynamic;
import com.horcrux.svg.FilterProperties;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.VirtualView;

public class FilterRegion {
    SVGLength mX;
    SVGLength mY;
    SVGLength mW;
    SVGLength mH;

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
    }

    private double getRelativeOrDefault(VirtualView view, SVGLength value, float relativeOn, double defaultValue) {
        if (value == null || value.unit == SVGLength.UnitType.UNKNOWN) {
            return defaultValue;
        }
        return view.relativeOn(value, relativeOn);
    }

    public Rect getCropRect(VirtualView view, FilterProperties.Units units, RectF bounds) {
        double height;
        double width;
        double y;
        double x;
        if (bounds == null) {
            return new Rect(0, 0, 0, 0);
        }
        if (units == FilterProperties.Units.OBJECT_BOUNDING_BOX) {
            x = (double)bounds.left + view.relativeOnFraction(this.mX, bounds.width());
            y = (double)bounds.top + view.relativeOnFraction(this.mY, bounds.height());
            width = view.relativeOnFraction(this.mW, bounds.width());
            height = view.relativeOnFraction(this.mH, bounds.height());
        } else {
            float canvasWidth = view.getSvgView().getCanvasWidth();
            float canvasHeight = view.getSvgView().getCanvasHeight();
            x = this.getRelativeOrDefault(view, this.mX, canvasWidth, bounds.left);
            y = this.getRelativeOrDefault(view, this.mY, canvasHeight, bounds.top);
            width = this.getRelativeOrDefault(view, this.mW, canvasWidth, bounds.width());
            height = this.getRelativeOrDefault(view, this.mH, canvasHeight, bounds.height());
        }
        return new Rect((int)x, (int)y, (int)(x + width), (int)(y + height));
    }
}

