/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.TextProperties;

class FontData {
    static final double DEFAULT_FONT_SIZE = 12.0;
    private static final double DEFAULT_KERNING = 0.0;
    private static final double DEFAULT_WORD_SPACING = 0.0;
    private static final double DEFAULT_LETTER_SPACING = 0.0;
    private static final String KERNING = "kerning";
    private static final String FONT_DATA = "fontData";
    private static final String TEXT_ANCHOR = "textAnchor";
    private static final String WORD_SPACING = "wordSpacing";
    private static final String LETTER_SPACING = "letterSpacing";
    private static final String TEXT_DECORATION = "textDecoration";
    private static final String FONT_FEATURE_SETTINGS = "fontFeatureSettings";
    private static final String FONT_VARIATION_SETTINGS = "fontVariationSettings";
    private static final String FONT_VARIANT_LIGATURES = "fontVariantLigatures";
    final double fontSize;
    final String fontFamily;
    final TextProperties.FontStyle fontStyle;
    final ReadableMap fontData;
    TextProperties.FontWeight fontWeight;
    int absoluteFontWeight;
    final String fontFeatureSettings;
    final String fontVariationSettings;
    final TextProperties.FontVariantLigatures fontVariantLigatures;
    final TextProperties.TextAnchor textAnchor;
    private final TextProperties.TextDecoration textDecoration;
    final double kerning;
    final double wordSpacing;
    final double letterSpacing;
    final boolean manualKerning;
    static final FontData Defaults = new FontData();

    private FontData() {
        this.fontData = null;
        this.fontFamily = "";
        this.fontStyle = TextProperties.FontStyle.normal;
        this.fontWeight = TextProperties.FontWeight.Normal;
        this.absoluteFontWeight = 400;
        this.fontFeatureSettings = "";
        this.fontVariationSettings = "";
        this.fontVariantLigatures = TextProperties.FontVariantLigatures.normal;
        this.textAnchor = TextProperties.TextAnchor.start;
        this.textDecoration = TextProperties.TextDecoration.None;
        this.manualKerning = false;
        this.kerning = 0.0;
        this.fontSize = 12.0;
        this.wordSpacing = 0.0;
        this.letterSpacing = 0.0;
    }

    private double toAbsolute(ReadableMap font, String prop, double scale, double fontSize, double relative) {
        ReadableType propType = font.getType(prop);
        if (propType == ReadableType.Number) {
            return font.getDouble(prop);
        }
        String string = font.getString(prop);
        return PropHelper.fromRelative(string, relative, scale, fontSize);
    }

    private void setInheritedWeight(FontData parent) {
        this.absoluteFontWeight = parent.absoluteFontWeight;
        this.fontWeight = parent.fontWeight;
    }

    private void handleNumericWeight(FontData parent, double number) {
        long weight = Math.round(number);
        if (weight >= 1L && weight <= 1000L) {
            this.absoluteFontWeight = (int)weight;
            this.fontWeight = AbsoluteFontWeight.nearestFontWeight(this.absoluteFontWeight);
        } else {
            this.setInheritedWeight(parent);
        }
    }

    FontData(ReadableMap font, FontData parent, double scale) {
        double parentFontSize = parent.fontSize;
        this.fontSize = font.hasKey("fontSize") ? this.toAbsolute(font, "fontSize", 1.0, parentFontSize, parentFontSize) : parentFontSize;
        if (font.hasKey("fontWeight")) {
            ReadableType fontWeightType = font.getType("fontWeight");
            if (fontWeightType == ReadableType.Number) {
                this.handleNumericWeight(parent, font.getDouble("fontWeight"));
            } else {
                String string = font.getString("fontWeight");
                if (TextProperties.FontWeight.hasEnum(string)) {
                    this.absoluteFontWeight = AbsoluteFontWeight.from(TextProperties.FontWeight.get(string), parent);
                    this.fontWeight = AbsoluteFontWeight.nearestFontWeight(this.absoluteFontWeight);
                } else if (string != null) {
                    this.handleNumericWeight(parent, Double.parseDouble(string));
                } else {
                    this.setInheritedWeight(parent);
                }
            }
        } else {
            this.setInheritedWeight(parent);
        }
        this.fontData = font.hasKey(FONT_DATA) ? font.getMap(FONT_DATA) : parent.fontData;
        this.fontFamily = font.hasKey("fontFamily") ? font.getString("fontFamily") : parent.fontFamily;
        this.fontStyle = font.hasKey("fontStyle") ? TextProperties.FontStyle.valueOf(font.getString("fontStyle")) : parent.fontStyle;
        this.fontFeatureSettings = font.hasKey(FONT_FEATURE_SETTINGS) ? font.getString(FONT_FEATURE_SETTINGS) : parent.fontFeatureSettings;
        this.fontVariationSettings = font.hasKey(FONT_VARIATION_SETTINGS) ? font.getString(FONT_VARIATION_SETTINGS) : parent.fontVariationSettings;
        this.fontVariantLigatures = font.hasKey(FONT_VARIANT_LIGATURES) ? TextProperties.FontVariantLigatures.valueOf(font.getString(FONT_VARIANT_LIGATURES)) : parent.fontVariantLigatures;
        this.textAnchor = font.hasKey(TEXT_ANCHOR) ? TextProperties.TextAnchor.valueOf(font.getString(TEXT_ANCHOR)) : parent.textAnchor;
        this.textDecoration = font.hasKey(TEXT_DECORATION) ? TextProperties.TextDecoration.getEnum(font.getString(TEXT_DECORATION)) : parent.textDecoration;
        boolean hasKerning = font.hasKey(KERNING);
        this.manualKerning = hasKerning || parent.manualKerning;
        this.kerning = hasKerning ? this.toAbsolute(font, KERNING, scale, this.fontSize, 0.0) : parent.kerning;
        this.wordSpacing = font.hasKey(WORD_SPACING) ? this.toAbsolute(font, WORD_SPACING, scale, this.fontSize, 0.0) : parent.wordSpacing;
        this.letterSpacing = font.hasKey(LETTER_SPACING) ? this.toAbsolute(font, LETTER_SPACING, scale, this.fontSize, 0.0) : parent.letterSpacing;
    }

    static class AbsoluteFontWeight {
        static final int normal = 400;
        private static final TextProperties.FontWeight[] WEIGHTS = new TextProperties.FontWeight[]{TextProperties.FontWeight.w100, TextProperties.FontWeight.w100, TextProperties.FontWeight.w200, TextProperties.FontWeight.w300, TextProperties.FontWeight.Normal, TextProperties.FontWeight.w500, TextProperties.FontWeight.w600, TextProperties.FontWeight.Bold, TextProperties.FontWeight.w800, TextProperties.FontWeight.w900, TextProperties.FontWeight.w900};
        private static final int[] absoluteFontWeights = new int[]{400, 700, 100, 200, 300, 400, 500, 600, 700, 800, 900};

        AbsoluteFontWeight() {
        }

        static TextProperties.FontWeight nearestFontWeight(int absoluteFontWeight) {
            return WEIGHTS[Math.round((float)absoluteFontWeight / 100.0f)];
        }

        static int from(TextProperties.FontWeight fontWeight, FontData parent) {
            if (fontWeight == TextProperties.FontWeight.Bolder) {
                return AbsoluteFontWeight.bolder(parent.absoluteFontWeight);
            }
            if (fontWeight == TextProperties.FontWeight.Lighter) {
                return AbsoluteFontWeight.lighter(parent.absoluteFontWeight);
            }
            return absoluteFontWeights[fontWeight.ordinal()];
        }

        private static int bolder(int inherited) {
            if (inherited < 350) {
                return 400;
            }
            if (inherited < 550) {
                return 700;
            }
            if (inherited < 900) {
                return 900;
            }
            return inherited;
        }

        private static int lighter(int inherited) {
            if (inherited < 100) {
                return inherited;
            }
            if (inherited < 550) {
                return 100;
            }
            if (inherited < 750) {
                return 400;
            }
            return 700;
        }
    }
}

