/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.MaskView;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.VirtualView;

@SuppressLint(value={"ViewConstructor"})
class ForeignObjectView
extends GroupView {
    SVGLength mX;
    SVGLength mY;
    SVGLength mW;
    SVGLength mH;
    Bitmap fakeBitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    Canvas fake = new Canvas(this.fakeBitmap);

    public ForeignObjectView(ReactContext reactContext) {
        super(reactContext);
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        float x = (float)this.relativeOnWidth(this.mX);
        float y = (float)this.relativeOnHeight(this.mY);
        float w = (float)this.relativeOnWidth(this.mW);
        float h = (float)this.relativeOnHeight(this.mH);
        canvas.translate(x, y);
        canvas.clipRect(0.0f, 0.0f, w, h);
        super.draw(canvas, paint, opacity);
    }

    public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
        super.onDescendantInvalidated(child, target);
        this.invalidate();
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    @Override
    void drawGroup(Canvas canvas, Paint paint, float opacity) {
        this.pushGlyphContext();
        SvgView svg = this.getSvgView();
        ForeignObjectView self = this;
        RectF groupRect = new RectF();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child instanceof MaskView) continue;
            if (child instanceof VirtualView) {
                VirtualView node = (VirtualView)child;
                if ("none".equals(node.mDisplay)) continue;
                if (node instanceof RenderableView) {
                    ((RenderableView)node).mergeProperties(self);
                }
                int count = node.saveAndSetupCanvas(canvas, this.mCTM);
                node.render(canvas, paint, opacity * this.mOpacity);
                RectF r = node.getClientRect();
                if (r != null) {
                    groupRect.union(r);
                }
                node.restoreCanvas(canvas, count);
                if (node instanceof RenderableView) {
                    ((RenderableView)node).resetProperties();
                }
                if (!node.isResponsible()) continue;
                svg.enableTouchEvents();
                continue;
            }
            if (child instanceof SvgView) {
                SvgView svgView = (SvgView)child;
                svgView.drawChildren(canvas);
                if (!svgView.isResponsible()) continue;
                svg.enableTouchEvents();
                continue;
            }
            child.draw(canvas);
        }
        this.setClientRect(groupRect);
        this.popGlyphContext();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(this.fake);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(this.fake, child, drawingTime);
    }
}

