/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import com.facebook.react.bridge.ReadableMap;
import com.horcrux.svg.FontData;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.TextView;
import java.util.ArrayList;
import javax.annotation.Nullable;

class GlyphContext {
    final ArrayList<FontData> mFontContext = new ArrayList();
    private final ArrayList<SVGLength[]> mXsContext = new ArrayList();
    private final ArrayList<SVGLength[]> mYsContext = new ArrayList();
    private final ArrayList<SVGLength[]> mDXsContext = new ArrayList();
    private final ArrayList<SVGLength[]> mDYsContext = new ArrayList();
    private final ArrayList<double[]> mRsContext = new ArrayList();
    private final ArrayList<Integer> mXIndices = new ArrayList();
    private final ArrayList<Integer> mYIndices = new ArrayList();
    private final ArrayList<Integer> mDXIndices = new ArrayList();
    private final ArrayList<Integer> mDYIndices = new ArrayList();
    private final ArrayList<Integer> mRIndices = new ArrayList();
    private final ArrayList<Integer> mXsIndices = new ArrayList();
    private final ArrayList<Integer> mYsIndices = new ArrayList();
    private final ArrayList<Integer> mDXsIndices = new ArrayList();
    private final ArrayList<Integer> mDYsIndices = new ArrayList();
    private final ArrayList<Integer> mRsIndices = new ArrayList();
    private double mFontSize = 12.0;
    private FontData topFont = FontData.Defaults;
    private double mX;
    private double mY;
    private double mDX;
    private double mDY;
    private SVGLength[] mXs = new SVGLength[0];
    private SVGLength[] mYs = new SVGLength[0];
    private SVGLength[] mDXs = new SVGLength[0];
    private SVGLength[] mDYs = new SVGLength[0];
    private double[] mRs = new double[]{0.0};
    private int mXsIndex;
    private int mYsIndex;
    private int mDXsIndex;
    private int mDYsIndex;
    private int mRsIndex;
    private int mXIndex = -1;
    private int mYIndex = -1;
    private int mDXIndex = -1;
    private int mDYIndex = -1;
    private int mRIndex = -1;
    private int mTop;
    private final float mScale;
    private final float mWidth;
    private final float mHeight;

    private void pushIndices() {
        this.mXsIndices.add(this.mXsIndex);
        this.mYsIndices.add(this.mYsIndex);
        this.mDXsIndices.add(this.mDXsIndex);
        this.mDYsIndices.add(this.mDYsIndex);
        this.mRsIndices.add(this.mRsIndex);
    }

    GlyphContext(float scale, float width, float height) {
        this.mScale = scale;
        this.mWidth = width;
        this.mHeight = height;
        this.mXsContext.add(this.mXs);
        this.mYsContext.add(this.mYs);
        this.mDXsContext.add(this.mDXs);
        this.mDYsContext.add(this.mDYs);
        this.mRsContext.add(this.mRs);
        this.mXIndices.add(this.mXIndex);
        this.mYIndices.add(this.mYIndex);
        this.mDXIndices.add(this.mDXIndex);
        this.mDYIndices.add(this.mDYIndex);
        this.mRIndices.add(this.mRIndex);
        this.mFontContext.add(this.topFont);
        this.pushIndices();
    }

    private void reset() {
        this.mRsIndex = 0;
        this.mDYsIndex = 0;
        this.mDXsIndex = 0;
        this.mYsIndex = 0;
        this.mXsIndex = 0;
        this.mRIndex = -1;
        this.mDYIndex = -1;
        this.mDXIndex = -1;
        this.mYIndex = -1;
        this.mXIndex = -1;
        this.mDY = 0.0;
        this.mDX = 0.0;
        this.mY = 0.0;
        this.mX = 0.0;
    }

    FontData getFont() {
        return this.topFont;
    }

    private FontData getTopOrParentFont(GroupView child) {
        if (this.mTop > 0) {
            return this.topFont;
        }
        for (GroupView parentRoot = child.getParentTextRoot(); parentRoot != null; parentRoot = parentRoot.getParentTextRoot()) {
            FontData map = parentRoot.getGlyphContext().getFont();
            if (map == FontData.Defaults) continue;
            return map;
        }
        return FontData.Defaults;
    }

    private void pushNodeAndFont(GroupView node, @Nullable ReadableMap font) {
        FontData parent = this.getTopOrParentFont(node);
        ++this.mTop;
        if (font == null) {
            this.mFontContext.add(parent);
            return;
        }
        FontData data = new FontData(font, parent, this.mScale);
        this.mFontSize = data.fontSize;
        this.mFontContext.add(data);
        this.topFont = data;
    }

    void pushContext(GroupView node, @Nullable ReadableMap font) {
        this.pushNodeAndFont(node, font);
        this.pushIndices();
    }

    private SVGLength[] getStringArrayFromReadableArray(ArrayList<SVGLength> readableArray) {
        int size = readableArray.size();
        SVGLength[] strings = new SVGLength[size];
        for (int i = 0; i < size; ++i) {
            strings[i] = readableArray.get(i);
        }
        return strings;
    }

    private double[] getDoubleArrayFromReadableArray(ArrayList<SVGLength> readableArray) {
        int size = readableArray.size();
        double[] doubles = new double[size];
        for (int i = 0; i < size; ++i) {
            SVGLength length = readableArray.get(i);
            doubles[i] = length.value;
        }
        return doubles;
    }

    void pushContext(boolean reset, TextView node, @Nullable ReadableMap font, @Nullable ArrayList<SVGLength> x, @Nullable ArrayList<SVGLength> y, @Nullable ArrayList<SVGLength> deltaX, @Nullable ArrayList<SVGLength> deltaY, @Nullable ArrayList<SVGLength> rotate) {
        if (reset) {
            this.reset();
        }
        this.pushNodeAndFont(node, font);
        if (x != null && x.size() != 0) {
            ++this.mXsIndex;
            this.mXIndex = -1;
            this.mXIndices.add(this.mXIndex);
            this.mXs = this.getStringArrayFromReadableArray(x);
            this.mXsContext.add(this.mXs);
        }
        if (y != null && y.size() != 0) {
            ++this.mYsIndex;
            this.mYIndex = -1;
            this.mYIndices.add(this.mYIndex);
            this.mYs = this.getStringArrayFromReadableArray(y);
            this.mYsContext.add(this.mYs);
        }
        if (deltaX != null && deltaX.size() != 0) {
            ++this.mDXsIndex;
            this.mDXIndex = -1;
            this.mDXIndices.add(this.mDXIndex);
            this.mDXs = this.getStringArrayFromReadableArray(deltaX);
            this.mDXsContext.add(this.mDXs);
        }
        if (deltaY != null && deltaY.size() != 0) {
            ++this.mDYsIndex;
            this.mDYIndex = -1;
            this.mDYIndices.add(this.mDYIndex);
            this.mDYs = this.getStringArrayFromReadableArray(deltaY);
            this.mDYsContext.add(this.mDYs);
        }
        if (rotate != null && rotate.size() != 0) {
            ++this.mRsIndex;
            this.mRIndex = -1;
            this.mRIndices.add(this.mRIndex);
            this.mRs = this.getDoubleArrayFromReadableArray(rotate);
            this.mRsContext.add(this.mRs);
        }
        this.pushIndices();
    }

    void popContext() {
        this.mFontContext.remove(this.mTop);
        this.mXsIndices.remove(this.mTop);
        this.mYsIndices.remove(this.mTop);
        this.mDXsIndices.remove(this.mTop);
        this.mDYsIndices.remove(this.mTop);
        this.mRsIndices.remove(this.mTop);
        --this.mTop;
        int x = this.mXsIndex;
        int y = this.mYsIndex;
        int dx = this.mDXsIndex;
        int dy = this.mDYsIndex;
        int r = this.mRsIndex;
        this.topFont = this.mFontContext.get(this.mTop);
        this.mXsIndex = this.mXsIndices.get(this.mTop);
        this.mYsIndex = this.mYsIndices.get(this.mTop);
        this.mDXsIndex = this.mDXsIndices.get(this.mTop);
        this.mDYsIndex = this.mDYsIndices.get(this.mTop);
        this.mRsIndex = this.mRsIndices.get(this.mTop);
        if (x != this.mXsIndex) {
            this.mXsContext.remove(x);
            this.mXs = this.mXsContext.get(this.mXsIndex);
            this.mXIndex = this.mXIndices.get(this.mXsIndex);
        }
        if (y != this.mYsIndex) {
            this.mYsContext.remove(y);
            this.mYs = this.mYsContext.get(this.mYsIndex);
            this.mYIndex = this.mYIndices.get(this.mYsIndex);
        }
        if (dx != this.mDXsIndex) {
            this.mDXsContext.remove(dx);
            this.mDXs = this.mDXsContext.get(this.mDXsIndex);
            this.mDXIndex = this.mDXIndices.get(this.mDXsIndex);
        }
        if (dy != this.mDYsIndex) {
            this.mDYsContext.remove(dy);
            this.mDYs = this.mDYsContext.get(this.mDYsIndex);
            this.mDYIndex = this.mDYIndices.get(this.mDYsIndex);
        }
        if (r != this.mRsIndex) {
            this.mRsContext.remove(r);
            this.mRs = this.mRsContext.get(this.mRsIndex);
            this.mRIndex = this.mRIndices.get(this.mRsIndex);
        }
    }

    private static void incrementIndices(ArrayList<Integer> indices, int topIndex) {
        for (int index = topIndex; index >= 0; --index) {
            int xIndex = indices.get(index);
            indices.set(index, xIndex + 1);
        }
    }

    double getFontSize() {
        return this.mFontSize;
    }

    double nextX(double advance) {
        GlyphContext.incrementIndices(this.mXIndices, this.mXsIndex);
        int nextIndex = this.mXIndex + 1;
        if (nextIndex < this.mXs.length) {
            this.mDX = 0.0;
            this.mXIndex = nextIndex;
            SVGLength string = this.mXs[nextIndex];
            this.mX = PropHelper.fromRelative(string, this.mWidth, 0.0, this.mScale, this.mFontSize);
        }
        this.mX += advance;
        return this.mX;
    }

    double nextY() {
        GlyphContext.incrementIndices(this.mYIndices, this.mYsIndex);
        int nextIndex = this.mYIndex + 1;
        if (nextIndex < this.mYs.length) {
            this.mDY = 0.0;
            this.mYIndex = nextIndex;
            SVGLength string = this.mYs[nextIndex];
            this.mY = PropHelper.fromRelative(string, this.mHeight, 0.0, this.mScale, this.mFontSize);
        }
        return this.mY;
    }

    double nextDeltaX() {
        GlyphContext.incrementIndices(this.mDXIndices, this.mDXsIndex);
        int nextIndex = this.mDXIndex + 1;
        if (nextIndex < this.mDXs.length) {
            this.mDXIndex = nextIndex;
            SVGLength string = this.mDXs[nextIndex];
            double val = PropHelper.fromRelative(string, this.mWidth, 0.0, this.mScale, this.mFontSize);
            this.mDX += val;
        }
        return this.mDX;
    }

    double nextDeltaY() {
        GlyphContext.incrementIndices(this.mDYIndices, this.mDYsIndex);
        int nextIndex = this.mDYIndex + 1;
        if (nextIndex < this.mDYs.length) {
            this.mDYIndex = nextIndex;
            SVGLength string = this.mDYs[nextIndex];
            double val = PropHelper.fromRelative(string, this.mHeight, 0.0, this.mScale, this.mFontSize);
            this.mDY += val;
        }
        return this.mDY;
    }

    double nextRotation() {
        GlyphContext.incrementIndices(this.mRIndices, this.mRsIndex);
        this.mRIndex = Math.min(this.mRIndex + 1, this.mRs.length - 1);
        return this.mRs[this.mRIndex];
    }

    float getWidth() {
        return this.mWidth;
    }

    float getHeight() {
        return this.mHeight;
    }
}

