/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Paint;
import android.graphics.Path;
import java.util.ArrayList;

class GlyphPathBag {
    private final ArrayList<Path> paths = new ArrayList();
    private final int[][] data = new int[256][];
    private final Paint paint;

    GlyphPathBag(Paint paint) {
        this.paint = paint;
        this.paths.add(new Path());
    }

    Path getOrCreateAndCache(char ch, String current) {
        Path cached;
        int index = this.getIndex(ch);
        if (index != 0) {
            cached = this.paths.get(index);
        } else {
            cached = new Path();
            this.paint.getTextPath(current, 0, 1, 0.0f, 0.0f, cached);
            int[] bin = this.data[ch >> 8];
            if (bin == null) {
                int[] nArray = new int[256];
                this.data[ch >> 8] = nArray;
                bin = nArray;
            }
            bin[ch & 0xFF] = this.paths.size();
            this.paths.add(cached);
        }
        Path glyph = new Path();
        glyph.addPath(cached);
        return glyph;
    }

    private int getIndex(char ch) {
        int[] bin = this.data[ch >> 8];
        if (bin == null) {
            return 0;
        }
        return bin[ch & 0xFF];
    }
}

