/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.view.View;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.views.view.ReactViewGroup;
import com.horcrux.svg.GlyphContext;
import com.horcrux.svg.MaskView;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.VirtualView;
import java.util.ArrayList;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
class GroupView
extends RenderableView {
    @Nullable
    ReadableMap mFont;
    private GlyphContext mGlyphContext;
    private Bitmap mLayerBitmap;
    private Canvas mLayerCanvas;
    private final Paint mLayerPaint = new Paint(1);

    public GroupView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setFont(Dynamic dynamic) {
        this.mFont = dynamic.getType() == ReadableType.Map ? dynamic.asMap() : null;
        this.invalidate();
    }

    public void setFont(@Nullable ReadableMap font) {
        this.mFont = font;
        this.invalidate();
    }

    void setupGlyphContext(Canvas canvas) {
        RectF clipBounds = new RectF(canvas.getClipBounds());
        if (this.mMatrix != null) {
            this.mMatrix.mapRect(clipBounds);
        }
        this.mGlyphContext = new GlyphContext(this.mScale, clipBounds.width(), clipBounds.height());
    }

    GlyphContext getGlyphContext() {
        return this.mGlyphContext;
    }

    private static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    GlyphContext getTextRootGlyphContext() {
        return GroupView.requireNonNull(this.getTextRoot()).getGlyphContext();
    }

    void pushGlyphContext() {
        this.getTextRootGlyphContext().pushContext(this, this.mFont);
    }

    void popGlyphContext() {
        this.getTextRootGlyphContext().popContext();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        this.setupGlyphContext(canvas);
        this.clip(canvas, paint);
        this.drawGroup(canvas, paint, opacity);
        this.renderMarkers(canvas, paint, opacity);
    }

    void drawGroup(Canvas canvas, Paint paint, float opacity) {
        this.pushGlyphContext();
        SvgView svg = this.getSvgView();
        GroupView self = this;
        RectF groupRect = new RectF();
        if (this.mOpacity != 1.0f) {
            if (this.mLayerBitmap == null) {
                this.mLayerBitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mLayerCanvas = new Canvas(this.mLayerBitmap);
            } else {
                this.mLayerBitmap.recycle();
                this.mLayerBitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mLayerCanvas.setBitmap(this.mLayerBitmap);
            }
            this.mLayerCanvas.save();
            this.mLayerCanvas.setMatrix(canvas.getMatrix());
        } else {
            this.mLayerCanvas = canvas;
        }
        this.elements = new ArrayList();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child instanceof MaskView) continue;
            if (child instanceof VirtualView) {
                VirtualView node = (VirtualView)child;
                if ("none".equals(node.mDisplay)) continue;
                if (node instanceof RenderableView) {
                    ((RenderableView)node).mergeProperties(self);
                }
                int count = node.saveAndSetupCanvas(this.mLayerCanvas, this.mCTM);
                node.render(this.mLayerCanvas, paint, opacity);
                RectF r = node.getClientRect();
                if (r != null) {
                    groupRect.union(r);
                }
                node.restoreCanvas(this.mLayerCanvas, count);
                if (node instanceof RenderableView) {
                    ((RenderableView)node).resetProperties();
                }
                if (node.isResponsible()) {
                    svg.enableTouchEvents();
                }
                if (node.elements == null) continue;
                this.elements.addAll(node.elements);
                continue;
            }
            if (!(child instanceof SvgView)) continue;
            SvgView svgView = (SvgView)child;
            svgView.drawChildren(canvas);
            if (!svgView.isResponsible()) continue;
            svg.enableTouchEvents();
        }
        if (this.mOpacity != 1.0f) {
            this.mLayerCanvas.restore();
            int saveCount = canvas.save();
            canvas.setMatrix(null);
            this.mLayerPaint.setAlpha((int)(this.mOpacity * 255.0f));
            canvas.drawBitmap(this.mLayerBitmap, 0.0f, 0.0f, this.mLayerPaint);
            canvas.restoreToCount(saveCount);
        }
        this.setClientRect(groupRect);
        this.popGlyphContext();
    }

    void drawPath(Canvas canvas, Paint paint, float opacity) {
        super.draw(canvas, paint, opacity);
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        if (this.mPath != null) {
            return this.mPath;
        }
        this.mPath = new Path();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (node instanceof MaskView || !(node instanceof VirtualView)) continue;
            VirtualView n = (VirtualView)node;
            Matrix transform = n.mMatrix;
            this.mPath.addPath(n.getPath(canvas, paint), transform);
        }
        return this.mPath;
    }

    Path getPath(Canvas canvas, Paint paint, Region.Op op) {
        Path path = new Path();
        if (Build.VERSION.SDK_INT >= 19) {
            Path.Op pop = Path.Op.valueOf((String)op.name());
            for (int i = 0; i < this.getChildCount(); ++i) {
                View node = this.getChildAt(i);
                if (node instanceof MaskView || !(node instanceof VirtualView)) continue;
                VirtualView n = (VirtualView)node;
                Matrix transform = n.mMatrix;
                Path p2 = n instanceof GroupView ? ((GroupView)n).getPath(canvas, paint, op) : n.getPath(canvas, paint);
                p2.transform(transform);
                path.op(p2, pop);
            }
        } else {
            Rect clipBounds = canvas.getClipBounds();
            Region bounds = new Region(clipBounds);
            Region r = new Region();
            for (int i = 0; i < this.getChildCount(); ++i) {
                View node = this.getChildAt(i);
                if (node instanceof MaskView || !(node instanceof VirtualView)) continue;
                VirtualView n = (VirtualView)node;
                Matrix transform = n.mMatrix;
                Path p2 = n instanceof GroupView ? ((GroupView)n).getPath(canvas, paint, op) : n.getPath(canvas, paint);
                if (transform != null) {
                    p2.transform(transform);
                }
                Region r2 = new Region();
                r2.setPath(p2, bounds);
                r.op(r2, op);
            }
            path.addPath(r.getBoundaryPath());
        }
        return path;
    }

    @Override
    int hitTest(float[] src) {
        if (!this.mInvertible) {
            return -1;
        }
        float[] dst = new float[2];
        this.mInvMatrix.mapPoints(dst, src);
        this.mInvTransform.mapPoints(dst);
        int x = Math.round(dst[0]);
        int y = Math.round(dst[1]);
        Path clipPath = this.getClipPath();
        if (clipPath != null) {
            if (this.mClipRegionPath != clipPath) {
                this.mClipRegionPath = clipPath;
                this.mClipBounds = new RectF();
                clipPath.computeBounds(this.mClipBounds, true);
                this.mClipRegion = this.getRegion(clipPath, this.mClipBounds);
            }
            if (!this.mClipRegion.contains(x, y)) {
                return -1;
            }
        }
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            ReactViewGroup node;
            int hitChild;
            View child = this.getChildAt(i);
            if (child instanceof VirtualView) {
                if (child instanceof MaskView || (hitChild = (node = (VirtualView)child).hitTest(dst)) == -1) continue;
                return node.isResponsible() || hitChild != child.getId() ? hitChild : this.getId();
            }
            if (!(child instanceof SvgView) || (hitChild = (node = (SvgView)child).reactTagForTouch(dst[0], dst[1])) == child.getId()) continue;
            return hitChild;
        }
        return -1;
    }

    @Override
    void saveDefinition() {
        if (this.mName != null) {
            this.getSvgView().defineTemplate(this, this.mName);
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (!(node instanceof VirtualView)) continue;
            ((VirtualView)node).saveDefinition();
        }
    }

    @Override
    void resetProperties() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (!(node instanceof RenderableView)) continue;
            ((RenderableView)node).resetProperties();
        }
    }
}

