/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
class LineView
extends RenderableView {
    private SVGLength mX1;
    private SVGLength mY1;
    private SVGLength mX2;
    private SVGLength mY2;

    public LineView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX1(Dynamic x1) {
        this.mX1 = SVGLength.from(x1);
        this.invalidate();
    }

    public void setY1(Dynamic y1) {
        this.mY1 = SVGLength.from(y1);
        this.invalidate();
    }

    public void setX2(Dynamic x2) {
        this.mX2 = SVGLength.from(x2);
        this.invalidate();
    }

    public void setY2(Dynamic y2) {
        this.mY2 = SVGLength.from(y2);
        this.invalidate();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        Path path = new Path();
        double x1 = this.relativeOnWidth(this.mX1);
        double y1 = this.relativeOnHeight(this.mY1);
        double x2 = this.relativeOnWidth(this.mX2);
        double y2 = this.relativeOnHeight(this.mY2);
        path.moveTo((float)x1, (float)y1);
        path.lineTo((float)x2, (float)y2);
        this.elements = new ArrayList();
        this.elements.add(new PathElement(ElementType.kCGPathElementMoveToPoint, new Point[]{new Point(x1, y1)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x2, y2)}));
        return path;
    }
}

