/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Path;
import android.graphics.RectF;
import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import java.util.ArrayList;

class PathParser {
    static float mScale;
    private static int i;
    private static int l;
    private static String s;
    private static Path mPath;
    static ArrayList<PathElement> elements;
    private static float mPenX;
    private static float mPenY;
    private static float mPivotX;
    private static float mPivotY;
    private static float mPenDownX;
    private static float mPenDownY;
    private static boolean mPenDown;

    PathParser() {
    }

    static Path parse(String d) {
        elements = new ArrayList();
        mPath = new Path();
        if (d == null) {
            return mPath;
        }
        char prev_cmd = ' ';
        l = d.length();
        s = d;
        i = 0;
        mPenX = 0.0f;
        mPenY = 0.0f;
        mPivotX = 0.0f;
        mPivotY = 0.0f;
        mPenDownX = 0.0f;
        mPenDownY = 0.0f;
        mPenDown = false;
        while (i < l) {
            char cmd;
            boolean is_implicit_move_to;
            PathParser.skip_spaces();
            if (i >= l) break;
            boolean has_prev_cmd = prev_cmd != ' ';
            char first_char = s.charAt(i);
            if (!has_prev_cmd && first_char != 'M' && first_char != 'm') {
                throw new IllegalArgumentException(String.format("Unexpected character '%c' (i=%d, s=%s)", Character.valueOf(first_char), i, s));
            }
            if (PathParser.is_cmd(first_char)) {
                is_implicit_move_to = false;
                cmd = first_char;
                ++i;
            } else if (PathParser.is_number_start(first_char) && has_prev_cmd) {
                if (prev_cmd == 'Z' || prev_cmd == 'z') {
                    throw new IllegalArgumentException(String.format("Unexpected number after 'z' (s=%s)", s));
                }
                if (prev_cmd == 'M' || prev_cmd == 'm') {
                    is_implicit_move_to = true;
                    cmd = PathParser.is_absolute(prev_cmd) ? (char)'L' : 'l';
                } else {
                    is_implicit_move_to = false;
                    cmd = prev_cmd;
                }
            } else {
                throw new IllegalArgumentException(String.format("Unexpected character '%c' (i=%d, s=%s)", Character.valueOf(first_char), i, s));
            }
            boolean absolute = PathParser.is_absolute(cmd);
            switch (cmd) {
                case 'm': {
                    PathParser.move(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'M': {
                    PathParser.moveTo(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'l': {
                    PathParser.line(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'L': {
                    PathParser.lineTo(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'h': {
                    PathParser.line(PathParser.parse_list_number(), 0.0f);
                    break;
                }
                case 'H': {
                    PathParser.lineTo(PathParser.parse_list_number(), mPenY);
                    break;
                }
                case 'v': {
                    PathParser.line(0.0f, PathParser.parse_list_number());
                    break;
                }
                case 'V': {
                    PathParser.lineTo(mPenX, PathParser.parse_list_number());
                    break;
                }
                case 'c': {
                    PathParser.curve(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'C': {
                    PathParser.curveTo(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 's': {
                    PathParser.smoothCurve(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'S': {
                    PathParser.smoothCurveTo(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'q': {
                    PathParser.quadraticBezierCurve(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'Q': {
                    PathParser.quadraticBezierCurveTo(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 't': {
                    PathParser.smoothQuadraticBezierCurve(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'T': {
                    PathParser.smoothQuadraticBezierCurveTo(PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'a': {
                    PathParser.arc(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_flag(), PathParser.parse_flag(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'A': {
                    PathParser.arcTo(PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_list_number(), PathParser.parse_flag(), PathParser.parse_flag(), PathParser.parse_list_number(), PathParser.parse_list_number());
                    break;
                }
                case 'Z': 
                case 'z': {
                    PathParser.close();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unexpected comand '%c' (s=%s)", Character.valueOf(cmd), s));
                }
            }
            if (is_implicit_move_to) {
                if (absolute) {
                    prev_cmd = 'M';
                    continue;
                }
                prev_cmd = 'm';
                continue;
            }
            prev_cmd = cmd;
        }
        return mPath;
    }

    private static void move(float x, float y) {
        PathParser.moveTo(x + mPenX, y + mPenY);
    }

    private static void moveTo(float x, float y) {
        mPivotX = mPenX = x;
        mPenDownX = mPenX;
        mPivotY = mPenY = y;
        mPenDownY = mPenY;
        mPath.moveTo(x * mScale, y * mScale);
        elements.add(new PathElement(ElementType.kCGPathElementMoveToPoint, new Point[]{new Point(x, y)}));
    }

    private static void line(float x, float y) {
        PathParser.lineTo(x + mPenX, y + mPenY);
    }

    private static void lineTo(float x, float y) {
        PathParser.setPenDown();
        mPivotX = mPenX = x;
        mPivotY = mPenY = y;
        mPath.lineTo(x * mScale, y * mScale);
        elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x, y)}));
    }

    private static void curve(float c1x, float c1y, float c2x, float c2y, float ex, float ey) {
        PathParser.curveTo(c1x + mPenX, c1y + mPenY, c2x + mPenX, c2y + mPenY, ex + mPenX, ey + mPenY);
    }

    private static void curveTo(float c1x, float c1y, float c2x, float c2y, float ex, float ey) {
        mPivotX = c2x;
        mPivotY = c2y;
        PathParser.cubicTo(c1x, c1y, c2x, c2y, ex, ey);
    }

    private static void cubicTo(float c1x, float c1y, float c2x, float c2y, float ex, float ey) {
        PathParser.setPenDown();
        mPenX = ex;
        mPenY = ey;
        mPath.cubicTo(c1x * mScale, c1y * mScale, c2x * mScale, c2y * mScale, ex * mScale, ey * mScale);
        elements.add(new PathElement(ElementType.kCGPathElementAddCurveToPoint, new Point[]{new Point(c1x, c1y), new Point(c2x, c2y), new Point(ex, ey)}));
    }

    private static void smoothCurve(float c1x, float c1y, float ex, float ey) {
        PathParser.smoothCurveTo(c1x + mPenX, c1y + mPenY, ex + mPenX, ey + mPenY);
    }

    private static void smoothCurveTo(float c1x, float c1y, float ex, float ey) {
        float c2x = c1x;
        float c2y = c1y;
        c1x = mPenX * 2.0f - mPivotX;
        c1y = mPenY * 2.0f - mPivotY;
        mPivotX = c2x;
        mPivotY = c2y;
        PathParser.cubicTo(c1x, c1y, c2x, c2y, ex, ey);
    }

    private static void quadraticBezierCurve(float c1x, float c1y, float c2x, float c2y) {
        PathParser.quadraticBezierCurveTo(c1x + mPenX, c1y + mPenY, c2x + mPenX, c2y + mPenY);
    }

    private static void quadraticBezierCurveTo(float c1x, float c1y, float c2x, float c2y) {
        mPivotX = c1x;
        mPivotY = c1y;
        float ex = c2x;
        float ey = c2y;
        c2x = (ex + c1x * 2.0f) / 3.0f;
        c2y = (ey + c1y * 2.0f) / 3.0f;
        c1x = (mPenX + c1x * 2.0f) / 3.0f;
        c1y = (mPenY + c1y * 2.0f) / 3.0f;
        PathParser.cubicTo(c1x, c1y, c2x, c2y, ex, ey);
    }

    private static void smoothQuadraticBezierCurve(float c1x, float c1y) {
        PathParser.smoothQuadraticBezierCurveTo(c1x + mPenX, c1y + mPenY);
    }

    private static void smoothQuadraticBezierCurveTo(float c1x, float c1y) {
        float c2x = c1x;
        float c2y = c1y;
        c1x = mPenX * 2.0f - mPivotX;
        c1y = mPenY * 2.0f - mPivotY;
        PathParser.quadraticBezierCurveTo(c1x, c1y, c2x, c2y);
    }

    private static void arc(float rx, float ry, float rotation, boolean outer, boolean clockwise, float x, float y) {
        PathParser.arcTo(rx, ry, rotation, outer, clockwise, x + mPenX, y + mPenY);
    }

    private static void arcTo(float rx, float ry, float rotation, boolean outer, boolean clockwise, float x, float y) {
        float cx;
        float rycx;
        float tX = mPenX;
        float tY = mPenY;
        ry = Math.abs(ry == 0.0f ? (rx == 0.0f ? y - tY : rx) : ry);
        rx = Math.abs(rx == 0.0f ? x - tX : rx);
        if (rx == 0.0f || ry == 0.0f || x == tX && y == tY) {
            PathParser.lineTo(x, y);
            return;
        }
        float rad = (float)Math.toRadians(rotation);
        float cos = (float)Math.cos(rad);
        float rxry = rx * rx * ry * ry;
        float sin = (float)Math.sin(rad);
        float cy = -sin * (x -= tX) / 2.0f + cos * (y -= tY) / 2.0f;
        float rxcy = rx * rx * cy * cy;
        float a = rxry - rxcy - (rycx = ry * ry * (cx = cos * x / 2.0f + sin * y / 2.0f) * cx);
        if (a < 0.0f) {
            a = (float)Math.sqrt(1.0f - a / rxry);
            rx *= a;
            ry *= a;
            cx = x / 2.0f;
            cy = y / 2.0f;
        } else {
            a = (float)Math.sqrt(a / (rxcy + rycx));
            if (outer == clockwise) {
                a = -a;
            }
            float cxd = -a * cy * rx / ry;
            float cyd = a * cx * ry / rx;
            cx = cos * cxd - sin * cyd + x / 2.0f;
            cy = sin * cxd + cos * cyd + y / 2.0f;
        }
        float xx = cos / rx;
        float yx = sin / rx;
        float xy = -sin / ry;
        float yy = cos / ry;
        float sa = (float)Math.atan2(xy * -cx + yy * -cy, xx * -cx + yx * -cy);
        float ea = (float)Math.atan2(xy * (x - cx) + yy * (y - cy), xx * (x - cx) + yx * (y - cy));
        cx += tX;
        cy += tY;
        PathParser.setPenDown();
        mPenX = mPivotX = (x += tX);
        mPenY = mPivotY = (y += tY);
        if (rx != ry || rad != 0.0f) {
            PathParser.arcToBezier(cx, cy, rx, ry, sa, ea, clockwise, rad);
        } else {
            float start = (float)Math.toDegrees(sa);
            float end = (float)Math.toDegrees(ea);
            float sweep = Math.abs((start - end) % 360.0f);
            if (outer) {
                if (sweep < 180.0f) {
                    sweep = 360.0f - sweep;
                }
            } else if (sweep > 180.0f) {
                sweep = 360.0f - sweep;
            }
            if (!clockwise) {
                sweep = -sweep;
            }
            RectF oval = new RectF((cx - rx) * mScale, (cy - rx) * mScale, (cx + rx) * mScale, (cy + rx) * mScale);
            mPath.arcTo(oval, start, sweep);
            elements.add(new PathElement(ElementType.kCGPathElementAddCurveToPoint, new Point[]{new Point(x, y)}));
        }
    }

    private static void close() {
        if (mPenDown) {
            mPenX = mPenDownX;
            mPenY = mPenDownY;
            mPenDown = false;
            mPath.close();
            elements.add(new PathElement(ElementType.kCGPathElementCloseSubpath, new Point[]{new Point(mPenX, mPenY)}));
        }
    }

    private static void arcToBezier(float cx, float cy, float rx, float ry, float sa, float ea, boolean clockwise, float rad) {
        float cos = (float)Math.cos(rad);
        float sin = (float)Math.sin(rad);
        float xx = cos * rx;
        float yx = -sin * ry;
        float xy = sin * rx;
        float yy = cos * ry;
        float arc = ea - sa;
        if (arc < 0.0f && clockwise) {
            arc = (float)((double)arc + Math.PI * 2);
        } else if (arc > 0.0f && !clockwise) {
            arc = (float)((double)arc - Math.PI * 2);
        }
        int n = (int)Math.ceil(Math.abs(PathParser.round((double)arc / 1.5707963267948966)));
        float step = arc / (float)n;
        float k = (float)(1.3333333333333333 * Math.tan(step / 4.0f));
        float x = (float)Math.cos(sa);
        float y = (float)Math.sin(sa);
        for (int i = 0; i < n; ++i) {
            float cp1x = x - k * y;
            float cp1y = y + k * x;
            x = (float)Math.cos(sa += step);
            y = (float)Math.sin(sa);
            float cp2x = x + k * y;
            float cp2y = y - k * x;
            float c1x = cx + xx * cp1x + yx * cp1y;
            float c1y = cy + xy * cp1x + yy * cp1y;
            float c2x = cx + xx * cp2x + yx * cp2y;
            float c2y = cy + xy * cp2x + yy * cp2y;
            float ex = cx + xx * x + yx * y;
            float ey = cy + xy * x + yy * y;
            mPath.cubicTo(c1x * mScale, c1y * mScale, c2x * mScale, c2y * mScale, ex * mScale, ey * mScale);
            elements.add(new PathElement(ElementType.kCGPathElementAddCurveToPoint, new Point[]{new Point(c1x, c1y), new Point(c2x, c2y), new Point(ex, ey)}));
        }
    }

    private static void setPenDown() {
        if (!mPenDown) {
            mPenDownX = mPenX;
            mPenDownY = mPenY;
            mPenDown = true;
        }
    }

    private static double round(double val) {
        double multiplier = Math.pow(10.0, 4.0);
        return (double)Math.round(val * multiplier) / multiplier;
    }

    private static void skip_spaces() {
        while (i < l && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
    }

    private static boolean is_cmd(char c) {
        switch (c) {
            case 'A': 
            case 'C': 
            case 'H': 
            case 'L': 
            case 'M': 
            case 'Q': 
            case 'S': 
            case 'T': 
            case 'V': 
            case 'Z': 
            case 'a': 
            case 'c': 
            case 'h': 
            case 'l': 
            case 'm': 
            case 'q': 
            case 's': 
            case 't': 
            case 'v': 
            case 'z': {
                return true;
            }
        }
        return false;
    }

    private static boolean is_number_start(char c) {
        return c >= '0' && c <= '9' || c == '.' || c == '-' || c == '+';
    }

    private static boolean is_absolute(char c) {
        return Character.isUpperCase(c);
    }

    private static boolean parse_flag() {
        PathParser.skip_spaces();
        char c = s.charAt(i);
        switch (c) {
            case '0': 
            case '1': {
                if (++i < l && s.charAt(i) == ',') {
                    ++i;
                }
                PathParser.skip_spaces();
                break;
            }
            default: {
                throw new Error(String.format("Unexpected flag '%c' (i=%d, s=%s)", Character.valueOf(c), i, s));
            }
        }
        return c == '1';
    }

    private static float parse_list_number() {
        if (i == l) {
            throw new Error(String.format("Unexpected end (s=%s)", s));
        }
        float n = PathParser.parse_number();
        PathParser.skip_spaces();
        PathParser.parse_list_separator();
        return n;
    }

    private static float parse_number() {
        String num;
        float n;
        char c2;
        PathParser.skip_spaces();
        if (i == l) {
            throw new Error(String.format("Unexpected end (s=%s)", s));
        }
        int start = i;
        char c = s.charAt(i);
        if (c == '-' || c == '+') {
            c = s.charAt(++i);
        }
        if (c >= '0' && c <= '9') {
            PathParser.skip_digits();
            if (i < l) {
                c = s.charAt(i);
            }
        } else if (c != '.') {
            throw new IllegalArgumentException(String.format("Invalid number formating character '%c' (i=%d, s=%s)", Character.valueOf(c), i, s));
        }
        if (c == '.') {
            PathParser.skip_digits();
            if (++i < l) {
                c = s.charAt(i);
            }
        }
        if ((c == 'e' || c == 'E') && i + 1 < l && (c2 = s.charAt(i + 1)) != 'm' && c2 != 'x') {
            if ((c = s.charAt(++i)) == '+' || c == '-') {
                ++i;
                PathParser.skip_digits();
            } else if (c >= '0' && c <= '9') {
                PathParser.skip_digits();
            } else {
                throw new IllegalArgumentException(String.format("Invalid number formating character '%c' (i=%d, s=%s)", Character.valueOf(c), i, s));
            }
        }
        if (Float.isInfinite(n = Float.parseFloat(num = s.substring(start, i))) || Float.isNaN(n)) {
            throw new IllegalArgumentException(String.format("Invalid number '%s' (start=%d, i=%d, s=%s)", num, start, i, s));
        }
        return n;
    }

    private static void parse_list_separator() {
        if (i < l && s.charAt(i) == ',') {
            ++i;
        }
    }

    private static void skip_digits() {
        while (i < l && Character.isDigit(s.charAt(i))) {
            ++i;
        }
    }
}

