/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.graphics.Region;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.horcrux.svg.NativeSvgRenderableModuleSpec;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.RenderableViewManager;
import com.horcrux.svg.SvgView;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

@ReactModule(name="RNSVGRenderableModule")
class RNSVGRenderableManager
extends NativeSvgRenderableModuleSpec {
    public static final String NAME = "RNSVGRenderableModule";
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    RNSVGRenderableManager(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public boolean isPointInFill(Double tag, ReadableMap options) {
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return false;
        }
        float scale = svg.mScale;
        float x = (float)options.getDouble("x") * scale;
        float y = (float)options.getDouble("y") * scale;
        int i = svg.hitTest(new float[]{x, y});
        return i != -1;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public boolean isPointInStroke(Double tag, ReadableMap options) {
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return false;
        }
        try {
            svg.getPath(null, null);
        }
        catch (NullPointerException e) {
            svg.invalidate();
            return false;
        }
        svg.initBounds();
        float scale = svg.mScale;
        int x = (int)(options.getDouble("x") * (double)scale);
        int y = (int)(options.getDouble("y") * (double)scale);
        Region strokeRegion = svg.mStrokeRegion;
        return strokeRegion != null && strokeRegion.contains(x, y);
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public double getTotalLength(Double tag) {
        Path path;
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return 0.0;
        }
        try {
            path = svg.getPath(null, null);
        }
        catch (NullPointerException e) {
            svg.invalidate();
            return -1.0;
        }
        PathMeasure pm = new PathMeasure(path, false);
        return pm.getLength() / svg.mScale;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public WritableMap getPointAtLength(Double tag, ReadableMap options) {
        Path path;
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return Arguments.createMap();
        }
        try {
            path = svg.getPath(null, null);
        }
        catch (NullPointerException e) {
            svg.invalidate();
            return Arguments.createMap();
        }
        PathMeasure pm = new PathMeasure(path, false);
        float length = (float)options.getDouble("length");
        float scale = svg.mScale;
        float[] pos = new float[2];
        float[] tan = new float[2];
        float distance = Math.max(0.0f, Math.min(length * scale, pm.getLength()));
        pm.getPosTan(distance, pos, tan);
        double angle = Math.atan2(tan[1], tan[0]);
        WritableMap result = Arguments.createMap();
        result.putDouble("x", (double)(pos[0] / scale));
        result.putDouble("y", (double)(pos[1] / scale));
        result.putDouble("angle", angle);
        return result;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public WritableMap getBBox(Double tag, ReadableMap options) {
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return Arguments.createMap();
        }
        boolean fill = options.getBoolean("fill");
        boolean stroke = options.getBoolean("stroke");
        boolean markers = options.getBoolean("markers");
        boolean clipped = options.getBoolean("clipped");
        try {
            svg.getPath(null, null);
        }
        catch (NullPointerException e) {
            svg.invalidate();
            return Arguments.createMap();
        }
        float scale = svg.mScale;
        svg.initBounds();
        RectF bounds = new RectF();
        RectF fillBounds = svg.mFillBounds;
        RectF strokeBounds = svg.mStrokeBounds;
        RectF markerBounds = svg.mMarkerBounds;
        RectF clipBounds = svg.mClipBounds;
        if (fill && fillBounds != null) {
            bounds.union(fillBounds);
        }
        if (stroke && strokeBounds != null) {
            bounds.union(strokeBounds);
        }
        if (markers && markerBounds != null) {
            bounds.union(markerBounds);
        }
        if (clipped && clipBounds != null) {
            bounds.intersect(clipBounds);
        }
        WritableMap result = Arguments.createMap();
        result.putDouble("x", (double)(bounds.left / scale));
        result.putDouble("y", (double)(bounds.top / scale));
        result.putDouble("width", (double)(bounds.width() / scale));
        result.putDouble("height", (double)(bounds.height() / scale));
        return result;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public WritableMap getCTM(Double tag) {
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return Arguments.createMap();
        }
        float scale = svg.mScale;
        Matrix ctm = new Matrix(svg.mCTM);
        SvgView svgView = svg.getSvgView();
        if (svgView == null) {
            throw new RuntimeException("Did not find parent SvgView for view with tag: " + tag);
        }
        Matrix invViewBoxMatrix = svgView.mInvViewBoxMatrix;
        ctm.preConcat(invViewBoxMatrix);
        float[] values = new float[9];
        ctm.getValues(values);
        WritableMap result = Arguments.createMap();
        result.putDouble("a", (double)values[0]);
        result.putDouble("b", (double)values[3]);
        result.putDouble("c", (double)values[1]);
        result.putDouble("d", (double)values[4]);
        result.putDouble("e", (double)(values[2] / scale));
        result.putDouble("f", (double)(values[5] / scale));
        return result;
    }

    @Override
    @ReactMethod(isBlockingSynchronousMethod=true)
    public WritableMap getScreenCTM(Double tag) {
        RenderableView svg = RenderableViewManager.getRenderableViewByTag(tag.intValue());
        if (svg == null) {
            return Arguments.createMap();
        }
        float[] values = new float[9];
        svg.mCTM.getValues(values);
        float scale = svg.mScale;
        WritableMap result = Arguments.createMap();
        result.putDouble("a", (double)values[0]);
        result.putDouble("b", (double)values[3]);
        result.putDouble("c", (double)values[1]);
        result.putDouble("d", (double)values[4]);
        result.putDouble("e", (double)(values[2] / scale));
        result.putDouble("f", (double)(values[5] / scale));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReactMethod
    public void getRawResource(String name, Promise promise) {
        try {
            ReactApplicationContext context = this.getReactApplicationContext();
            Resources resources = context.getResources();
            String packageName = context.getPackageName();
            int id = resources.getIdentifier(name, "raw", packageName);
            InputStream stream = resources.openRawResource(id);
            try {
                int n;
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                char[] buffer = new char[4096];
                StringBuilder builder = new StringBuilder();
                while ((n = reader.read(buffer, 0, 4096)) != -1) {
                    builder.append(buffer, 0, n);
                }
                String result = builder.toString();
                promise.resolve((Object)result);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject((Throwable)e);
        }
    }
}

