/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.ElementType;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.Point;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
class RectView
extends RenderableView {
    private SVGLength mX;
    private SVGLength mY;
    private SVGLength mW;
    private SVGLength mH;
    private SVGLength mRx;
    private SVGLength mRy;

    public RectView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setX(Dynamic x) {
        this.mX = SVGLength.from(x);
        this.invalidate();
    }

    public void setY(Dynamic y) {
        this.mY = SVGLength.from(y);
        this.invalidate();
    }

    public void setWidth(Dynamic width) {
        this.mW = SVGLength.from(width);
        this.invalidate();
    }

    public void setHeight(Dynamic height) {
        this.mH = SVGLength.from(height);
        this.invalidate();
    }

    public void setRx(Dynamic rx) {
        this.mRx = SVGLength.from(rx);
        this.invalidate();
    }

    public void setRy(Dynamic ry) {
        this.mRy = SVGLength.from(ry);
        this.invalidate();
    }

    @Override
    Path getPath(Canvas canvas, Paint paint) {
        Path path = new Path();
        double x = this.relativeOnWidth(this.mX);
        double y = this.relativeOnHeight(this.mY);
        double w = this.relativeOnWidth(this.mW);
        double h = this.relativeOnHeight(this.mH);
        if (this.mRx != null || this.mRy != null) {
            double rx = 0.0;
            double ry = 0.0;
            if (this.mRx == null) {
                rx = ry = this.relativeOnHeight(this.mRy);
            } else if (this.mRy == null) {
                ry = rx = this.relativeOnWidth(this.mRx);
            } else {
                rx = this.relativeOnWidth(this.mRx);
                ry = this.relativeOnHeight(this.mRy);
            }
            if (rx > w / 2.0) {
                rx = w / 2.0;
            }
            if (ry > h / 2.0) {
                ry = h / 2.0;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                path.addRoundRect((float)x, (float)y, (float)(x + w), (float)(y + h), (float)rx, (float)ry, Path.Direction.CW);
            } else {
                path.addRoundRect(new RectF((float)x, (float)y, (float)(x + w), (float)(y + h)), (float)rx, (float)ry, Path.Direction.CW);
            }
        } else {
            path.addRect((float)x, (float)y, (float)(x + w), (float)(y + h), Path.Direction.CW);
            path.close();
        }
        this.elements = new ArrayList();
        this.elements.add(new PathElement(ElementType.kCGPathElementMoveToPoint, new Point[]{new Point(x, y)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x + w, y)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x + w, y + h)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x, y + h)}));
        this.elements.add(new PathElement(ElementType.kCGPathElementAddLineToPoint, new Point[]{new Point(x, y)}));
        return path;
    }
}

