/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.view.ViewParent;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.uimanager.PointerEvents;
import com.horcrux.svg.Brush;
import com.horcrux.svg.FilterView;
import com.horcrux.svg.ImageView;
import com.horcrux.svg.MarkerView;
import com.horcrux.svg.MaskView;
import com.horcrux.svg.RNSVGMarkerPosition;
import com.horcrux.svg.RNSVGMarkerType;
import com.horcrux.svg.RenderableViewManager;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import com.horcrux.svg.VirtualView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class RenderableView
extends VirtualView
implements ReactHitSlopView {
    static RenderableView contextElement;
    private static final int CAP_BUTT = 0;
    static final int CAP_ROUND = 1;
    private static final int CAP_SQUARE = 2;
    private static final int JOIN_BEVEL = 2;
    private static final int JOIN_MITER = 0;
    static final int JOIN_ROUND = 1;
    private static final int FILL_RULE_EVENODD = 0;
    static final int FILL_RULE_NONZERO = 1;
    private static final int VECTOR_EFFECT_DEFAULT = 0;
    private static final int VECTOR_EFFECT_NON_SCALING_STROKE = 1;
    public int vectorEffect = 0;
    @Nullable
    public ReadableArray stroke;
    @Nullable
    public SVGLength[] strokeDasharray;
    public SVGLength strokeWidth = new SVGLength(1.0);
    public float strokeOpacity = 1.0f;
    public float strokeMiterlimit = 4.0f;
    public float strokeDashoffset = 0.0f;
    public Paint.Cap strokeLinecap = Paint.Cap.BUTT;
    public Paint.Join strokeLinejoin = Paint.Join.MITER;
    private int mCurrentColor = 0;
    @Nullable
    public ReadableArray fill;
    public float fillOpacity = 1.0f;
    public Path.FillType fillRule = Path.FillType.WINDING;
    @Nullable
    private ArrayList<String> mLastMergedList;
    @Nullable
    private ArrayList<Object> mOriginProperties;
    @Nullable
    private ArrayList<String> mPropList;
    @Nullable
    private ArrayList<String> mAttributeList;
    @Nullable
    private RenderableView mCaller;
    @Nullable
    String mFilter;
    private static final Pattern regex;

    RenderableView(ReactContext reactContext) {
        super(reactContext);
        this.setPivotX(0.0f);
        this.setPivotY(0.0f);
    }

    @Nullable
    public Rect getHitSlopRect() {
        if (this.mPointerEvents == PointerEvents.BOX_NONE) {
            return new Rect(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        return null;
    }

    public void setId(int id) {
        super.setId(id);
        RenderableViewManager.setRenderableView(id, this);
    }

    public void setVectorEffect(int vectorEffect) {
        this.vectorEffect = vectorEffect;
        this.invalidate();
    }

    public void setCurrentColor(Integer color) {
        this.mCurrentColor = color != null ? color : 0;
        this.invalidate();
        this.clearChildCache();
    }

    int getCurrentColor() {
        if (this.mCurrentColor != 0) {
            return this.mCurrentColor;
        }
        if (this.mCaller != null) {
            return this.mCaller.getCurrentColor();
        }
        ViewParent parent = this.getParent();
        if (parent instanceof VirtualView) {
            return ((RenderableView)parent).getCurrentColor();
        }
        if (parent instanceof SvgView) {
            return ((SvgView)parent).mCurrentColor;
        }
        return 0;
    }

    public void setFill(@Nullable Dynamic fill) {
        if (fill == null || fill.isNull()) {
            this.fill = null;
            this.invalidate();
            return;
        }
        ReadableType fillType = fill.getType();
        if (fillType.equals((Object)ReadableType.Map)) {
            ReadableMap fillMap = fill.asMap();
            this.setFill(fillMap);
            return;
        }
        if (fillType.equals((Object)ReadableType.Number)) {
            this.fill = JavaOnlyArray.of((Object[])new Object[]{0, fill.asInt()});
        } else if (fillType.equals((Object)ReadableType.Array)) {
            this.fill = fill.asArray();
        } else {
            JavaOnlyArray arr = new JavaOnlyArray();
            arr.pushInt(0);
            Matcher m = regex.matcher(fill.asString());
            int i = 0;
            while (m.find()) {
                double parsed = Double.parseDouble(m.group());
                arr.pushDouble(i++ < 3 ? parsed / 255.0 : parsed);
            }
            this.fill = arr;
        }
        this.invalidate();
    }

    public void setFill(ReadableMap fill) {
        if (fill == null) {
            this.fill = null;
            this.invalidate();
            return;
        }
        int type = fill.getInt("type");
        if (type == 0) {
            ReadableType valueType = fill.getType("payload");
            if (valueType.equals((Object)ReadableType.Number)) {
                this.fill = JavaOnlyArray.of((Object[])new Object[]{0, fill.getInt("payload")});
            } else if (valueType.equals((Object)ReadableType.Map)) {
                this.fill = JavaOnlyArray.of((Object[])new Object[]{0, fill.getMap("payload")});
            }
        } else {
            this.fill = type == 1 ? JavaOnlyArray.of((Object[])new Object[]{1, fill.getString("brushRef")}) : JavaOnlyArray.of((Object[])new Object[]{type});
        }
        this.invalidate();
    }

    public void setFillOpacity(float fillOpacity) {
        this.fillOpacity = fillOpacity;
        this.invalidate();
    }

    public void setFillRule(int fillRule) {
        switch (fillRule) {
            case 0: {
                this.fillRule = Path.FillType.EVEN_ODD;
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("fillRule " + fillRule + " unrecognized");
            }
        }
        this.invalidate();
    }

    public void setStroke(@Nullable Dynamic strokeColors) {
        if (strokeColors == null || strokeColors.isNull()) {
            this.stroke = null;
            this.invalidate();
            return;
        }
        ReadableType strokeType = strokeColors.getType();
        if (strokeType.equals((Object)ReadableType.Map)) {
            ReadableMap strokeMap = strokeColors.asMap();
            this.setStroke(strokeMap);
            return;
        }
        ReadableType type = strokeColors.getType();
        if (type.equals((Object)ReadableType.Number)) {
            this.stroke = JavaOnlyArray.of((Object[])new Object[]{0, strokeColors.asInt()});
        } else if (type.equals((Object)ReadableType.Array)) {
            this.stroke = strokeColors.asArray();
        } else {
            JavaOnlyArray arr = new JavaOnlyArray();
            arr.pushInt(0);
            Matcher m = regex.matcher(strokeColors.asString());
            int i = 0;
            while (m.find()) {
                double parsed = Double.parseDouble(m.group());
                arr.pushDouble(i++ < 3 ? parsed / 255.0 : parsed);
            }
            this.stroke = arr;
        }
        this.invalidate();
    }

    public void setStroke(@Nullable ReadableMap stroke) {
        if (stroke == null) {
            this.stroke = null;
            this.invalidate();
            return;
        }
        int type = stroke.getInt("type");
        if (type == 0) {
            ReadableType payloadType = stroke.getType("payload");
            if (payloadType.equals((Object)ReadableType.Number)) {
                this.stroke = JavaOnlyArray.of((Object[])new Object[]{0, stroke.getInt("payload")});
            } else if (payloadType.equals((Object)ReadableType.Map)) {
                this.stroke = JavaOnlyArray.of((Object[])new Object[]{0, stroke.getMap("payload")});
            }
        } else {
            this.stroke = type == 1 ? JavaOnlyArray.of((Object[])new Object[]{1, stroke.getString("brushRef")}) : JavaOnlyArray.of((Object[])new Object[]{type});
        }
        this.invalidate();
    }

    public void setStrokeOpacity(float strokeOpacity) {
        this.strokeOpacity = strokeOpacity;
        this.invalidate();
    }

    public void setStrokeDasharray(Dynamic dynamicStrokeDasharray) {
        ArrayList<SVGLength> arrayList = SVGLength.arrayFrom(dynamicStrokeDasharray);
        if (arrayList != null) {
            if (arrayList.size() % 2 == 1) {
                arrayList.addAll(arrayList);
            }
            this.strokeDasharray = arrayList.toArray(new SVGLength[0]);
        } else {
            this.strokeDasharray = null;
        }
        this.invalidate();
    }

    public void setStrokeDashoffset(float strokeDashoffset) {
        this.strokeDashoffset = strokeDashoffset * this.mScale;
        this.invalidate();
    }

    public void setStrokeWidth(Dynamic strokeWidth) {
        this.strokeWidth = strokeWidth.isNull() ? new SVGLength(1.0) : SVGLength.from(strokeWidth);
        this.invalidate();
    }

    public void setStrokeMiterlimit(float strokeMiterlimit) {
        this.strokeMiterlimit = strokeMiterlimit;
        this.invalidate();
    }

    public void setStrokeLinecap(int strokeLinecap) {
        switch (strokeLinecap) {
            case 0: {
                this.strokeLinecap = Paint.Cap.BUTT;
                break;
            }
            case 2: {
                this.strokeLinecap = Paint.Cap.SQUARE;
                break;
            }
            case 1: {
                this.strokeLinecap = Paint.Cap.ROUND;
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeLinecap " + strokeLinecap + " unrecognized");
            }
        }
        this.invalidate();
    }

    public void setStrokeLinejoin(int strokeLinejoin) {
        switch (strokeLinejoin) {
            case 0: {
                this.strokeLinejoin = Paint.Join.MITER;
                break;
            }
            case 2: {
                this.strokeLinejoin = Paint.Join.BEVEL;
                break;
            }
            case 1: {
                this.strokeLinejoin = Paint.Join.ROUND;
                break;
            }
            default: {
                throw new JSApplicationIllegalArgumentException("strokeLinejoin " + strokeLinejoin + " unrecognized");
            }
        }
        this.invalidate();
    }

    public void setPropList(@Nullable ReadableArray propList) {
        if (propList != null) {
            this.mAttributeList = new ArrayList();
            this.mPropList = this.mAttributeList;
            for (int i = 0; i < propList.size(); ++i) {
                this.mPropList.add(propList.getString(i));
            }
        }
        this.invalidate();
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
        this.invalidate();
    }

    @Override
    void render(Canvas canvas, Paint paint, float opacity) {
        SvgView root;
        MaskView mask = null;
        FilterView filter = null;
        if (this.mMask != null) {
            root = this.getSvgView();
            mask = (MaskView)root.getDefinedMask(this.mMask);
        }
        if (this.mFilter != null) {
            root = this.getSvgView();
            filter = (FilterView)root.getDefinedFilter(this.mFilter);
        }
        if (mask != null || filter != null) {
            if (filter != null) {
                Paint bitmapPaint = new Paint(2);
                canvas.saveLayer(null, bitmapPaint);
                Bitmap backgroundBitmap = this.getSvgView().getCurrentBitmap();
                Bitmap elementBitmap = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas elementCanvas = new Canvas(elementBitmap);
                elementCanvas.setMatrix(canvas.getMatrix());
                this.draw(elementCanvas, paint, opacity);
                this.initBounds();
                RectF clientRect = this.getClientRect();
                if (this instanceof ImageView && clientRect == null) {
                    return;
                }
                elementBitmap = filter.applyFilter(elementBitmap, backgroundBitmap, clientRect);
                int saveCount = canvas.save();
                canvas.setMatrix(null);
                canvas.drawBitmap(elementBitmap, 0.0f, 0.0f, bitmapPaint);
                canvas.restoreToCount(saveCount);
            } else {
                canvas.saveLayer(null, new Paint());
                this.draw(canvas, paint, opacity);
            }
            if (mask != null) {
                RectF maskBounds;
                Paint dstInPaint = new Paint();
                dstInPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                canvas.saveLayer(null, dstInPaint);
                if (mask.getMaskType() == MaskView.MaskType.LUMINANCE) {
                    Paint luminancePaint = new Paint();
                    ColorMatrix luminanceToAlpha = new ColorMatrix(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.2125f, 0.7154f, 0.0721f, 0.0f, 0.0f});
                    luminancePaint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(luminanceToAlpha));
                    canvas.saveLayer(null, luminancePaint);
                } else {
                    canvas.saveLayer(null, paint);
                }
                if (mask.getMaskUnits() == Brush.BrushUnits.USER_SPACE_ON_USE) {
                    float maskX = (float)this.relativeOnWidth(mask.mX);
                    float maskY = (float)this.relativeOnHeight(mask.mY);
                    float maskWidth = (float)this.relativeOnWidth(mask.mW);
                    float maskHeight = (float)this.relativeOnHeight(mask.mH);
                    maskBounds = new RectF(maskX, maskY, maskX + maskWidth, maskY + maskHeight);
                } else {
                    RectF clientRect = this.getClientRect();
                    if (this instanceof ImageView && clientRect == null) {
                        return;
                    }
                    this.mInvCTM.mapRect(clientRect);
                    float maskX = (float)this.relativeOnFraction(mask.mX, clientRect.width());
                    float maskY = (float)this.relativeOnFraction(mask.mY, clientRect.height());
                    float maskWidth = (float)this.relativeOnFraction(mask.mW, clientRect.width());
                    float maskHeight = (float)this.relativeOnFraction(mask.mH, clientRect.height());
                    maskBounds = new RectF(clientRect.left + maskX, clientRect.top + maskY, clientRect.left + maskX + maskWidth, clientRect.top + maskY + maskHeight);
                }
                canvas.clipRect(maskBounds);
                mask.draw(canvas, paint, 1.0f);
                canvas.restore();
                canvas.saveLayer(null, dstInPaint);
                canvas.clipRect(maskBounds);
                mask.draw(canvas, paint, 1.0f);
                canvas.restore();
                canvas.restore();
            }
            canvas.restore();
        } else {
            this.draw(canvas, paint, opacity);
        }
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        boolean computePaths;
        opacity *= this.mOpacity;
        boolean bl = computePaths = this.mPath == null;
        if (computePaths) {
            this.mPath = this.getPath(canvas, paint);
            this.mPath.setFillType(this.fillRule);
        }
        boolean nonScalingStroke = this.vectorEffect == 1;
        Path path = this.mPath;
        if (nonScalingStroke) {
            Path scaled = new Path();
            this.mPath.transform(this.mCTM, scaled);
            canvas.setMatrix(null);
            path = scaled;
        }
        if (computePaths || path != this.mPath) {
            this.mBox = new RectF();
            path.computeBounds(this.mBox, true);
        }
        RectF clientRect = new RectF(this.mBox);
        this.mCTM.mapRect(clientRect);
        this.setClientRect(clientRect);
        this.clip(canvas, paint);
        if (this.setupFillPaint(paint, opacity * this.fillOpacity)) {
            if (computePaths) {
                this.mFillPath = new Path();
                paint.getFillPath(path, this.mFillPath);
            }
            canvas.drawPath(path, paint);
        }
        if (this.setupStrokePaint(paint, opacity * this.strokeOpacity)) {
            if (computePaths) {
                this.mStrokePath = new Path();
                paint.getFillPath(path, this.mStrokePath);
            }
            canvas.drawPath(path, paint);
        }
        this.renderMarkers(canvas, paint, opacity);
    }

    void renderMarkers(Canvas canvas, Paint paint, float opacity) {
        MarkerView markerStart = (MarkerView)this.getSvgView().getDefinedMarker(this.mMarkerStart);
        MarkerView markerMid = (MarkerView)this.getSvgView().getDefinedMarker(this.mMarkerMid);
        MarkerView markerEnd = (MarkerView)this.getSvgView().getDefinedMarker(this.mMarkerEnd);
        if (this.elements != null && (markerStart != null || markerMid != null || markerEnd != null)) {
            contextElement = this;
            ArrayList<RNSVGMarkerPosition> positions = RNSVGMarkerPosition.fromPath(this.elements);
            float width = (float)(this.strokeWidth != null ? this.relativeOnOther(this.strokeWidth) : 1.0);
            this.mMarkerPath = new Path();
            for (RNSVGMarkerPosition position : positions) {
                RNSVGMarkerType type = position.type;
                MarkerView marker = null;
                switch (type) {
                    case kStartMarker: {
                        marker = markerStart;
                        break;
                    }
                    case kMidMarker: {
                        marker = markerMid;
                        break;
                    }
                    case kEndMarker: {
                        marker = markerEnd;
                    }
                }
                if (marker == null) continue;
                marker.renderMarker(canvas, paint, opacity, position, width);
                Matrix transform = marker.markerTransform;
                this.mMarkerPath.addPath(marker.getPath(canvas, paint), transform);
            }
            contextElement = null;
        }
    }

    boolean setupFillPaint(Paint paint, float opacity) {
        if (this.fill != null && this.fill.size() > 0) {
            paint.reset();
            paint.setFlags(385);
            paint.setStyle(Paint.Style.FILL);
            this.setupPaint(paint, opacity, this.fill);
            return true;
        }
        return false;
    }

    boolean setupStrokePaint(Paint paint, float opacity) {
        paint.reset();
        double strokeWidth = this.relativeOnOther(this.strokeWidth);
        if (strokeWidth == 0.0 || this.stroke == null || this.stroke.size() == 0) {
            return false;
        }
        paint.setFlags(385);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeCap(this.strokeLinecap);
        paint.setStrokeJoin(this.strokeLinejoin);
        paint.setStrokeMiter(this.strokeMiterlimit * this.mScale);
        paint.setStrokeWidth((float)strokeWidth);
        this.setupPaint(paint, opacity, this.stroke);
        if (this.strokeDasharray != null) {
            int length = this.strokeDasharray.length;
            float[] intervals = new float[length];
            for (int i = 0; i < length; ++i) {
                intervals[i] = (float)this.relativeOnOther(this.strokeDasharray[i]);
            }
            paint.setPathEffect((PathEffect)new DashPathEffect(intervals, this.strokeDashoffset));
        }
        return true;
    }

    private void setupPaint(Paint paint, float opacity, ReadableArray colors) {
        int colorType = colors.getInt(0);
        switch (colorType) {
            case 0: {
                if (colors.size() == 2) {
                    int color = colors.getType(1) == ReadableType.Map ? ColorPropConverter.getColor((Object)colors.getMap(1), (Context)this.getContext()).intValue() : colors.getInt(1);
                    int alpha = color >>> 24;
                    int combined = Math.round((float)alpha * opacity);
                    paint.setColor(combined << 24 | color & 0xFFFFFF);
                    break;
                }
                paint.setARGB((int)(colors.size() > 4 ? colors.getDouble(4) * (double)opacity * 255.0 : (double)(opacity * 255.0f)), (int)(colors.getDouble(1) * 255.0), (int)(colors.getDouble(2) * 255.0), (int)(colors.getDouble(3) * 255.0));
                break;
            }
            case 1: {
                Brush brush = this.getSvgView().getDefinedBrush(colors.getString(1));
                if (brush == null) break;
                brush.setupPaint(paint, this.mBox, this.mScale, opacity);
                break;
            }
            case 2: {
                int color = this.getCurrentColor();
                int alpha = color >>> 24;
                alpha = Math.round((float)alpha * opacity);
                paint.setColor(alpha << 24 | color & 0xFFFFFF);
                break;
            }
            case 3: {
                if (contextElement == null || RenderableView.contextElement.fill == null) break;
                this.setupPaint(paint, opacity, RenderableView.contextElement.fill);
                break;
            }
            case 4: {
                if (contextElement == null || RenderableView.contextElement.stroke == null) break;
                this.setupPaint(paint, opacity, RenderableView.contextElement.stroke);
            }
        }
    }

    @Override
    abstract Path getPath(Canvas var1, Paint var2);

    @Override
    int hitTest(float[] src) {
        if (this.mPath == null || !this.mInvertible) {
            return -1;
        }
        if (this.mPointerEvents == PointerEvents.NONE) {
            return -1;
        }
        float[] dst = new float[2];
        this.mInvMatrix.mapPoints(dst, src);
        this.mInvTransform.mapPoints(dst);
        int x = Math.round(dst[0]);
        int y = Math.round(dst[1]);
        this.initBounds();
        if (!(this.mRegion != null && this.mRegion.contains(x, y) || this.mStrokeRegion != null && (this.mStrokeRegion.contains(x, y) || this.mMarkerRegion != null && this.mMarkerRegion.contains(x, y)))) {
            return -1;
        }
        Path clipPath = this.getClipPath();
        if (clipPath != null && !this.mClipRegion.contains(x, y)) {
            return -1;
        }
        return this.getId();
    }

    void initBounds() {
        Path clipPath;
        if (this.mRegion == null && this.mFillPath != null) {
            this.mFillBounds = new RectF();
            this.mFillPath.computeBounds(this.mFillBounds, true);
            this.mRegion = this.getRegion(this.mFillPath, this.mFillBounds);
        }
        if (this.mRegion == null && this.mPath != null) {
            this.mFillBounds = new RectF();
            this.mPath.computeBounds(this.mFillBounds, true);
            this.mRegion = this.getRegion(this.mPath, this.mFillBounds);
        }
        if (this.mStrokeRegion == null && this.mStrokePath != null) {
            this.mStrokeBounds = new RectF();
            this.mStrokePath.computeBounds(this.mStrokeBounds, true);
            this.mStrokeRegion = this.getRegion(this.mStrokePath, this.mStrokeBounds);
        }
        if (this.mMarkerRegion == null && this.mMarkerPath != null) {
            this.mMarkerBounds = new RectF();
            this.mMarkerPath.computeBounds(this.mMarkerBounds, true);
            this.mMarkerRegion = this.getRegion(this.mMarkerPath, this.mMarkerBounds);
        }
        if ((clipPath = this.getClipPath()) != null && this.mClipRegionPath != clipPath) {
            this.mClipRegionPath = clipPath;
            this.mClipBounds = new RectF();
            clipPath.computeBounds(this.mClipBounds, true);
            this.mClipRegion = this.getRegion(clipPath, this.mClipBounds);
        }
    }

    Region getRegion(Path path, RectF rectF) {
        Region region = new Region();
        region.setPath(path, new Region((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom)));
        return region;
    }

    private ArrayList<String> getAttributeList() {
        return this.mAttributeList;
    }

    void mergeProperties(RenderableView target) {
        this.mCaller = target;
        ArrayList<String> targetAttributeList = target.getAttributeList();
        if (targetAttributeList == null || targetAttributeList.size() == 0) {
            return;
        }
        this.mOriginProperties = new ArrayList();
        this.mAttributeList = this.mPropList == null ? new ArrayList() : new ArrayList<String>(this.mPropList);
        int size = targetAttributeList.size();
        for (int i = 0; i < size; ++i) {
            try {
                String fieldName = targetAttributeList.get(i);
                Field field = ((Object)((Object)this)).getClass().getField(fieldName);
                Object value = field.get((Object)target);
                this.mOriginProperties.add(field.get((Object)this));
                if (this.hasOwnProperty(fieldName)) continue;
                this.mAttributeList.add(fieldName);
                field.set((Object)this, value);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.mLastMergedList = targetAttributeList;
    }

    void resetProperties() {
        if (this.mLastMergedList != null && this.mOriginProperties != null) {
            try {
                for (int i = this.mLastMergedList.size() - 1; i >= 0; --i) {
                    Field field = ((Object)((Object)this)).getClass().getField(this.mLastMergedList.get(i));
                    field.set((Object)this, this.mOriginProperties.get(i));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.mLastMergedList = null;
            this.mOriginProperties = null;
            this.mAttributeList = this.mPropList;
            this.mCaller = null;
        }
    }

    private boolean hasOwnProperty(String propName) {
        return this.mAttributeList != null && this.mAttributeList.contains(propName);
    }

    static {
        regex = Pattern.compile("[0-9.-]+");
    }
}

