/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.Base64;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactCompoundViewGroup;
import com.facebook.react.views.view.ReactViewGroup;
import com.horcrux.svg.Brush;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgViewManager;
import com.horcrux.svg.ViewBox;
import com.horcrux.svg.VirtualView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
public class SvgView
extends ReactViewGroup
implements ReactCompoundView,
ReactCompoundViewGroup {
    @Nullable
    private Bitmap mBitmap;
    @Nullable
    private Bitmap mCurrentBitmap;
    private boolean mRemovalTransitionStarted;
    private Runnable toDataUrlTask = null;
    private boolean mResponsible = false;
    private final Map<String, VirtualView> mDefinedClipPaths = new HashMap<String, VirtualView>();
    private final Map<String, VirtualView> mDefinedTemplates = new HashMap<String, VirtualView>();
    private final Map<String, VirtualView> mDefinedMarkers = new HashMap<String, VirtualView>();
    private final Map<String, VirtualView> mDefinedMasks = new HashMap<String, VirtualView>();
    private final Map<String, VirtualView> mDefinedFilters = new HashMap<String, VirtualView>();
    private final Map<String, Brush> mDefinedBrushes = new HashMap<String, Brush>();
    private Canvas mCanvas;
    private final float mScale;
    private final Paint mPaint = new Paint();
    private float mMinX;
    private float mMinY;
    private float mVbWidth;
    private float mVbHeight;
    private SVGLength mbbWidth;
    private SVGLength mbbHeight;
    private String mAlign;
    private int mMeetOrSlice;
    final Matrix mInvViewBoxMatrix = new Matrix();
    private boolean mInvertible = true;
    private boolean mRendered = false;
    int mCurrentColor = -16777216;

    public boolean interceptsTouchEvent(float touchX, float touchY) {
        return true;
    }

    public SvgView(ReactContext reactContext) {
        super((Context)reactContext);
        this.mScale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
        this.mPaint.setFlags(385);
        this.mPaint.setTypeface(Typeface.DEFAULT);
        this.setWillNotDraw(false);
    }

    public void setId(int id) {
        super.setId(id);
        SvgViewManager.setSvgView(id, this);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        Rect r = new Rect();
        boolean isVisible = this.getGlobalVisibleRect(r);
        info.setVisibleToUser(isVisible);
        info.setClassName((CharSequence)((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void invalidate() {
        super.invalidate();
        ViewParent parent = this.getParent();
        if (parent instanceof VirtualView) {
            if (!this.mRendered) {
                return;
            }
            this.mRendered = false;
            ((VirtualView)parent).getSvgView().invalidate();
            return;
        }
        if (!this.mRemovalTransitionStarted) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mBitmap = null;
        }
    }

    public void startViewTransition(View view) {
        this.mRemovalTransitionStarted = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
        this.mBitmap = null;
    }

    protected void onDraw(Canvas canvas) {
        if (this.getParent() instanceof VirtualView) {
            return;
        }
        super.onDraw(canvas);
        if (this.mBitmap == null) {
            this.mBitmap = this.drawOutput();
        }
        if (this.mBitmap != null) {
            this.mPaint.reset();
            this.mPaint.setFlags(387);
            this.mPaint.setTypeface(Typeface.DEFAULT);
            canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mPaint);
            if (this.toDataUrlTask != null) {
                this.toDataUrlTask.run();
                this.toDataUrlTask = null;
            }
        }
    }

    void setToDataUrlTask(Runnable task) {
        this.toDataUrlTask = task;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.invalidate();
    }

    public int reactTagForTouch(float touchX, float touchY) {
        return this.hitTest(touchX, touchY);
    }

    boolean notRendered() {
        return !this.mRendered;
    }

    private void clearChildCache() {
        if (!this.mRendered) {
            return;
        }
        this.mRendered = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (!(node instanceof VirtualView)) continue;
            VirtualView n = (VirtualView)node;
            n.clearChildCache();
        }
    }

    public void setCurrentColor(Integer color) {
        this.mCurrentColor = color != null ? color : 0;
        this.invalidate();
        this.clearChildCache();
    }

    public void setMinX(float minX) {
        this.mMinX = minX;
        this.invalidate();
        this.clearChildCache();
    }

    public void setMinY(float minY) {
        this.mMinY = minY;
        this.invalidate();
        this.clearChildCache();
    }

    public void setVbWidth(float vbWidth) {
        this.mVbWidth = vbWidth;
        this.invalidate();
        this.clearChildCache();
    }

    public void setVbHeight(float vbHeight) {
        this.mVbHeight = vbHeight;
        this.invalidate();
        this.clearChildCache();
    }

    public void setBbWidth(Dynamic bbWidth) {
        this.mbbWidth = SVGLength.from(bbWidth);
        this.invalidate();
        this.clearChildCache();
    }

    public void setBbHeight(Dynamic bbHeight) {
        this.mbbHeight = SVGLength.from(bbHeight);
        this.invalidate();
        this.clearChildCache();
    }

    public void setAlign(String align) {
        this.mAlign = align;
        this.invalidate();
        this.clearChildCache();
    }

    public void setMeetOrSlice(int meetOrSlice) {
        this.mMeetOrSlice = meetOrSlice;
        this.invalidate();
        this.clearChildCache();
    }

    private Bitmap drawOutput() {
        Bitmap bitmap;
        boolean invalid;
        this.mRendered = true;
        float width = this.getWidth();
        float height = this.getHeight();
        boolean bl = invalid = Float.isNaN(width) || Float.isNaN(height) || width < 1.0f || height < 1.0f || Math.log10(width) + Math.log10(height) > 42.0;
        if (invalid) {
            return null;
        }
        this.mCurrentBitmap = bitmap = Bitmap.createBitmap((int)((int)width), (int)((int)height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.drawChildren(new Canvas(bitmap));
        return bitmap;
    }

    Rect getCanvasBounds() {
        return this.mCanvas.getClipBounds();
    }

    float getCanvasWidth() {
        return this.mCanvas.getWidth();
    }

    float getCanvasHeight() {
        return this.mCanvas.getHeight();
    }

    Matrix getCtm() {
        return this.mCanvas.getMatrix();
    }

    synchronized void drawChildren(Canvas canvas) {
        int i;
        this.mRendered = true;
        this.mCanvas = canvas;
        Matrix mViewBoxMatrix = new Matrix();
        if (this.mAlign != null) {
            RectF vbRect = this.getViewBox();
            float width = canvas.getWidth();
            float height = canvas.getHeight();
            boolean nested = this.getParent() instanceof VirtualView;
            if (nested) {
                width = (float)PropHelper.fromRelative(this.mbbWidth, width, 0.0, this.mScale, 12.0);
                height = (float)PropHelper.fromRelative(this.mbbHeight, height, 0.0, this.mScale, 12.0);
            }
            RectF eRect = new RectF(0.0f, 0.0f, width, height);
            if (nested) {
                canvas.clipRect(eRect);
            }
            mViewBoxMatrix = ViewBox.getTransform(vbRect, eRect, this.mAlign, this.mMeetOrSlice);
            this.mInvertible = mViewBoxMatrix.invert(this.mInvViewBoxMatrix);
            canvas.concat(mViewBoxMatrix);
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (!(node instanceof VirtualView)) continue;
            ((VirtualView)node).saveDefinition();
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            View lNode = this.getChildAt(i);
            if (!(lNode instanceof VirtualView)) continue;
            VirtualView node = (VirtualView)lNode;
            int count = node.saveAndSetupCanvas(canvas, mViewBoxMatrix);
            node.render(canvas, this.mPaint, 1.0f);
            node.restoreCanvas(canvas, count);
            if (!node.isResponsible() || this.mResponsible) continue;
            this.mResponsible = true;
        }
    }

    private RectF getViewBox() {
        return new RectF(this.mMinX * this.mScale, this.mMinY * this.mScale, (this.mMinX + this.mVbWidth) * this.mScale, (this.mMinY + this.mVbHeight) * this.mScale);
    }

    String toDataURL() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.clearChildCache();
        this.drawChildren(new Canvas(bitmap));
        this.clearChildCache();
        this.invalidate();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        bitmap.recycle();
        byte[] bitmapBytes = stream.toByteArray();
        return Base64.encodeToString((byte[])bitmapBytes, (int)2);
    }

    String toDataURL(int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.clearChildCache();
        this.drawChildren(new Canvas(bitmap));
        this.clearChildCache();
        this.invalidate();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
        bitmap.recycle();
        byte[] bitmapBytes = stream.toByteArray();
        return Base64.encodeToString((byte[])bitmapBytes, (int)2);
    }

    void enableTouchEvents() {
        if (!this.mResponsible) {
            this.mResponsible = true;
        }
    }

    boolean isResponsible() {
        return this.mResponsible;
    }

    private int hitTest(float touchX, float touchY) {
        if (!this.mResponsible || !this.mInvertible) {
            return this.getId();
        }
        float[] transformed = new float[]{touchX, touchY};
        this.mInvViewBoxMatrix.mapPoints(transformed);
        int count = this.getChildCount();
        int viewTag = -1;
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child instanceof VirtualView) {
                viewTag = ((VirtualView)child).hitTest(transformed);
            } else if (child instanceof SvgView) {
                viewTag = ((SvgView)child).hitTest(touchX, touchY);
            }
            if (viewTag != -1) break;
        }
        return viewTag == -1 ? this.getId() : viewTag;
    }

    void defineClipPath(VirtualView clipPath, String clipPathRef) {
        this.mDefinedClipPaths.put(clipPathRef, clipPath);
    }

    VirtualView getDefinedClipPath(String clipPathRef) {
        return this.mDefinedClipPaths.get(clipPathRef);
    }

    void defineTemplate(VirtualView template, String templateRef) {
        this.mDefinedTemplates.put(templateRef, template);
    }

    VirtualView getDefinedTemplate(String templateRef) {
        return this.mDefinedTemplates.get(templateRef);
    }

    void defineBrush(Brush brush, String brushRef) {
        this.mDefinedBrushes.put(brushRef, brush);
    }

    Brush getDefinedBrush(String brushRef) {
        return this.mDefinedBrushes.get(brushRef);
    }

    void defineMask(VirtualView mask, String maskRef) {
        this.mDefinedMasks.put(maskRef, mask);
    }

    VirtualView getDefinedMask(String maskRef) {
        return this.mDefinedMasks.get(maskRef);
    }

    void defineFilter(VirtualView filter, String filterRef) {
        this.mDefinedFilters.put(filterRef, filter);
    }

    VirtualView getDefinedFilter(String filterRef) {
        return this.mDefinedFilters.get(filterRef);
    }

    void defineMarker(VirtualView marker, String markerRef) {
        this.mDefinedMarkers.put(markerRef, marker);
    }

    VirtualView getDefinedMarker(String markerRef) {
        return this.mDefinedMarkers.get(markerRef);
    }

    public Bitmap getCurrentBitmap() {
        return this.mCurrentBitmap;
    }

    public static enum Events {
        EVENT_DATA_URL("onDataURL");

        private final String mName;

        private Events(String name) {
            this.mName = name;
        }

        @Nonnull
        public String toString() {
            return this.mName;
        }
    }
}

