/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import com.facebook.react.bridge.ReactContext;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.ViewBox;

@SuppressLint(value={"ViewConstructor"})
class SymbolView
extends GroupView {
    private float mMinX;
    private float mMinY;
    private float mVbWidth;
    private float mVbHeight;
    private String mAlign;
    private int mMeetOrSlice;

    public SymbolView(ReactContext reactContext) {
        super(reactContext);
    }

    public void setMinX(float minX) {
        this.mMinX = minX;
        this.invalidate();
    }

    public void setMinY(float minY) {
        this.mMinY = minY;
        this.invalidate();
    }

    public void setVbWidth(float vbWidth) {
        this.mVbWidth = vbWidth;
        this.invalidate();
    }

    public void setVbHeight(float vbHeight) {
        this.mVbHeight = vbHeight;
        this.invalidate();
    }

    public void setAlign(String align) {
        this.mAlign = align;
        this.invalidate();
    }

    public void setMeetOrSlice(int meetOrSlice) {
        this.mMeetOrSlice = meetOrSlice;
        this.invalidate();
    }

    @Override
    void draw(Canvas canvas, Paint paint, float opacity) {
        this.saveDefinition();
    }

    void drawSymbol(Canvas canvas, Paint paint, float opacity, float width, float height) {
        if (this.mAlign != null) {
            RectF vbRect = new RectF(this.mMinX * this.mScale, this.mMinY * this.mScale, (this.mMinX + this.mVbWidth) * this.mScale, (this.mMinY + this.mVbHeight) * this.mScale);
            RectF eRect = new RectF(0.0f, 0.0f, width, height);
            Matrix viewBoxMatrix = ViewBox.getTransform(vbRect, eRect, this.mAlign, this.mMeetOrSlice);
            canvas.concat(viewBoxMatrix);
            super.draw(canvas, paint, opacity);
        }
    }
}

