/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.view.View;
import com.horcrux.svg.TSpanView;
import com.horcrux.svg.TextPathView;
import com.horcrux.svg.TextProperties;
import com.horcrux.svg.TextView;
import java.util.ArrayList;

class TextLayoutAlgorithm {
    TextLayoutAlgorithm() {
    }

    private void getSubTreeTypographicCharacterPositions(ArrayList<TextPathView> inTextPath, ArrayList<TextView> subtree, StringBuilder line, View node, TextPathView textPath) {
        if (node instanceof TSpanView) {
            TSpanView tSpanView = (TSpanView)node;
            String content = tSpanView.mContent;
            if (content == null) {
                for (int i = 0; i < tSpanView.getChildCount(); ++i) {
                    this.getSubTreeTypographicCharacterPositions(inTextPath, subtree, line, tSpanView.getChildAt(i), textPath);
                }
            } else {
                for (int i = 0; i < content.length(); ++i) {
                    subtree.add(tSpanView);
                    inTextPath.add(textPath);
                }
                line.append(content);
            }
        } else {
            textPath = node instanceof TextPathView ? (TextPathView)node : textPath;
            for (int i = 0; i < textPath.getChildCount(); ++i) {
                this.getSubTreeTypographicCharacterPositions(inTextPath, subtree, line, textPath.getChildAt(i), textPath);
            }
        }
    }

    CharacterInformation[] layoutText(LayoutInput layoutInput) {
        int index;
        TextView text = layoutInput.text;
        StringBuilder line = new StringBuilder();
        ArrayList<TextView> subtree = new ArrayList<TextView>();
        ArrayList<TextPathView> inTextPath = new ArrayList<TextPathView>();
        this.getSubTreeTypographicCharacterPositions(inTextPath, subtree, line, (View)text, null);
        char[] root = line.toString().toCharArray();
        int count = root.length;
        final CharacterInformation[] result = new CharacterInformation[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new CharacterInformation(i, root[i]);
        }
        if (count == 0) {
            return result;
        }
        PointF[] CSS_positions = new PointF[count];
        for (int i = 0; i < count; ++i) {
            CSS_positions[i] = new PointF(0.0f, 0.0f);
        }
        boolean horizontal = true;
        for (int i = 0; i < count; ++i) {
            result[i].addressable = true;
            result[i].middle = false;
            boolean bl = result[i].anchoredChunk = i == 0;
            if (result[i].addressable && !result[i].middle) {
                CSS_positions[i].set(0.0f, 0.0f);
                continue;
            }
            if (i <= 0) continue;
            CSS_positions[i].set(CSS_positions[i - 1]);
        }
        String[] resolve_x = new String[count];
        String[] resolve_y = new String[count];
        String[] resolve_dx = new String[count];
        String[] resolve_dy = new String[count];
        boolean in_text_path = false;
        class CharacterPositioningResolver {
            private int global = 0;
            private boolean horizontal = true;
            private boolean in_text_path = false;
            private CharacterInformation[] result;
            private String[] resolve_x;
            private String[] resolve_y;
            private String[] resolve_dx;
            private String[] resolve_dy;

            private CharacterPositioningResolver(CharacterInformation[] result, String[] resolve_x, String[] resolve_y, String[] resolve_dx, String[] resolve_dy) {
                this.result = result;
                this.resolve_x = resolve_x;
                this.resolve_y = resolve_y;
                this.resolve_dx = resolve_dx;
                this.resolve_dy = resolve_dy;
            }

            private void resolveCharacterPositioning(TextView node) {
                if (((Object)((Object)node)).getClass() == TextView.class || ((Object)((Object)node)).getClass() == TSpanView.class) {
                    int index = this.global;
                    String[] x = new String[]{};
                    String[] y = new String[]{};
                    String[] dx = new String[]{};
                    String[] dy = new String[]{};
                    double[] rotate = new double[]{};
                    int new_chunk_count = !this.in_text_path ? Math.max(x.length, y.length) : (this.horizontal ? x.length : y.length);
                    String content = ((TSpanView)node).mContent;
                    int length = content == null ? 0 : content.length();
                    int i = 0;
                    for (int j = 0; j < length; ++j) {
                        if (this.result[index + j].addressable) {
                            boolean bl = this.result[index + j].anchoredChunk = i < new_chunk_count;
                            if (i < x.length) {
                                this.resolve_x[index + j] = x[i];
                            }
                            if (this.in_text_path && !this.horizontal) {
                                this.resolve_x[index] = "";
                            }
                            if (i < y.length) {
                                this.resolve_y[index + j] = y[i];
                            }
                            if (this.in_text_path && this.horizontal) {
                                this.resolve_y[index] = "";
                            }
                            if (i < dx.length) {
                                this.resolve_dx[index + j] = dx[i];
                            }
                            if (i < dy.length) {
                                this.resolve_dy[index + j] = dy[i];
                            }
                            if (i < rotate.length) {
                                this.result[index + j].rotate = rotate[i];
                            } else if (rotate.length != 0) {
                                this.result[index + j].rotate = this.result[index + j - 1].rotate;
                            }
                        }
                        ++i;
                    }
                } else if (((Object)((Object)node)).getClass() == TextPathView.class) {
                    int index = this.global;
                    this.result[index].anchoredChunk = true;
                    this.in_text_path = true;
                    for (int child = 0; child < node.getChildCount(); ++child) {
                        this.resolveCharacterPositioning((TextView)node.getChildAt(child));
                    }
                    if (node instanceof TextPathView) {
                        this.in_text_path = false;
                    }
                }
            }
        }
        CharacterPositioningResolver resolver = new CharacterPositioningResolver(result, resolve_x, resolve_y, resolve_dx, resolve_dy);
        PointF shift = new PointF(0.0f, 0.0f);
        for (int i = 0; i < count; ++i) {
            if (resolve_x[i].equals("")) {
                resolve_x[i] = "0";
            }
            if (resolve_y[i].equals("")) {
                resolve_y[i] = "0";
            }
            shift.x += Float.parseFloat(resolve_x[i]);
            shift.y += Float.parseFloat(resolve_y[i]);
            result[i].x = CSS_positions[i].x + shift.x;
            result[i].y = CSS_positions[i].y + shift.y;
        }
        class TextLengthResolver {
            int global;

            TextLengthResolver() {
            }

            private void resolveTextLength(TextView node) {
                boolean validTextLength;
                Class<?> nodeClass = ((Object)((Object)node)).getClass();
                boolean bl = validTextLength = node.mTextLength != null;
                if (nodeClass == TSpanView.class && validTextLength) {
                    double a = Double.POSITIVE_INFINITY;
                    double b = Double.NEGATIVE_INFINITY;
                    String content = ((TSpanView)node).mContent;
                    int i = this.global;
                    int j = i + (content == null ? 0 : content.length());
                    for (int k = i; k <= j; ++k) {
                        if (!result[i].addressable) continue;
                        switch (result[i].character) {
                            case '\n': 
                            case '\r': {
                                return;
                            }
                        }
                        double pos = result[k].x;
                        double advance = result[k].advance;
                        a = Math.min(a, Math.min(pos, pos + advance));
                        b = Math.max(b, Math.max(pos, pos + advance));
                    }
                    if (a != Double.POSITIVE_INFINITY) {
                        double delta = node.mTextLength.value - (b - a);
                        int n = 0;
                        int resolvedDescendantNodes = 0;
                        for (int c = 0; c < node.getChildCount(); ++c) {
                            if (((TextPathView)node.getChildAt((int)c)).mTextLength == null) {
                                String ccontent = ((TSpanView)node).mContent;
                                n += ccontent == null ? 0 : ccontent.length();
                                continue;
                            }
                            result[n].firstCharacterInResolvedDescendant = true;
                            ++resolvedDescendantNodes;
                        }
                        double perCharacterAdjustment = delta / (double)(n += resolvedDescendantNodes - 1);
                        double shift = 0.0;
                        for (int k = i; k <= j; ++k) {
                            result[k].x += shift;
                            if (result[k].middle || result[k].resolved && !result[k].firstCharacterInResolvedDescendant) continue;
                            shift += perCharacterAdjustment;
                        }
                    }
                }
            }
        }
        TextLengthResolver lengthResolver = new TextLengthResolver();
        lengthResolver.resolveTextLength(text);
        shift.set(0.0f, 0.0f);
        for (index = 1; index < count; ++index) {
            if (resolve_x[index] != null) {
                shift.x = (float)(Double.parseDouble(resolve_x[index]) - result[index].x);
            }
            if (resolve_y[index] != null) {
                shift.y = (float)(Double.parseDouble(resolve_y[index]) - result[index].y);
            }
            result[index].x += (double)shift.x;
            result[index].y += (double)shift.y;
            if (result[index].middle && result[index].anchoredChunk) {
                result[index].anchoredChunk = false;
            }
            if (index + 1 >= count) continue;
            result[index + 1].anchoredChunk = true;
        }
        int i = 0;
        double a = Double.POSITIVE_INFINITY;
        double b = Double.NEGATIVE_INFINITY;
        double prevA = Double.POSITIVE_INFINITY;
        double prevB = Double.NEGATIVE_INFINITY;
        for (int k = 0; k < count; ++k) {
            if (!result[k].addressable) continue;
            if (result[k].anchoredChunk) {
                prevA = a;
                prevB = b;
                a = Double.POSITIVE_INFINITY;
                b = Double.NEGATIVE_INFINITY;
            }
            double pos = result[k].x;
            double advance = result[k].advance;
            a = Math.min(a, Math.min(pos, pos + advance));
            b = Math.max(b, Math.max(pos, pos + advance));
            if ((k <= 0 || !result[k].anchoredChunk || prevA == Double.POSITIVE_INFINITY) && k != count - 1) continue;
            TextProperties.TextAnchor anchor = TextProperties.TextAnchor.start;
            TextProperties.Direction direction = TextProperties.Direction.ltr;
            if (k == count - 1) {
                prevA = a;
                prevB = b;
            }
            double anchorShift = result[i].x;
            switch (anchor) {
                case start: {
                    if (direction == TextProperties.Direction.ltr) {
                        anchorShift -= prevA;
                        break;
                    }
                    anchorShift -= prevB;
                    break;
                }
                case middle: {
                    if (direction == TextProperties.Direction.ltr) {
                        anchorShift -= (prevA + prevB) / 2.0;
                        break;
                    }
                    anchorShift -= (prevA + prevB) / 2.0;
                    break;
                }
                case end: {
                    if (direction == TextProperties.Direction.ltr) {
                        anchorShift -= prevB;
                        break;
                    }
                    anchorShift -= prevA;
                }
            }
            int j = k == count - 1 ? k : k - 1;
            for (int r = i; r <= j; ++r) {
                result[r].x += anchorShift;
            }
            i = k;
        }
        boolean inPath = false;
        boolean afterPath = false;
        PointF path_end = new PointF(0.0f, 0.0f);
        Path textPath = null;
        PathMeasure pm = new PathMeasure();
        for (index = 0; index < count; ++index) {
            TextPathView textPathView = inTextPath.get(index);
            if (textPathView != null && result[index].addressable) {
                textPath = textPathView.getTextPath(null, null);
                inPath = true;
                if (!result[index].middle) {
                    Path path = textPath;
                    if (textPathView.getSide() == TextProperties.TextPathSide.right) {
                        // empty if block
                    }
                    pm.setPath(path, false);
                    double length = pm.getLength();
                    double offset = textPathView.getStartOffset().value;
                    double advance = result[index].advance;
                    double x = result[index].x;
                    double y = result[index].y;
                    double angle = result[index].rotate;
                    double mid = x + advance / 2.0 + offset;
                    if (!pm.isClosed() && (mid < 0.0 || mid > length)) {
                        result[index].hidden = true;
                    }
                    if (pm.isClosed()) {
                        TextProperties.TextAnchor anchor = TextProperties.TextAnchor.start;
                        TextProperties.Direction direction = TextProperties.Direction.ltr;
                        double anchorShift = result[i].x;
                        switch (anchor) {
                            case start: {
                                if (direction == TextProperties.Direction.ltr) {
                                    if (!(mid < 0.0) && !(mid > length)) break;
                                    result[index].hidden = true;
                                    break;
                                }
                                if (!(mid < -length) && !(mid > 0.0)) break;
                                result[index].hidden = true;
                                break;
                            }
                            case middle: {
                                if (!(mid < -length / 2.0) && !(mid > length / 2.0)) break;
                                result[index].hidden = true;
                                break;
                            }
                            case end: {
                                if (direction == TextProperties.Direction.ltr) {
                                    if (!(mid < -length) && !(mid > 0.0)) break;
                                    result[index].hidden = true;
                                    break;
                                }
                                if (!(mid < 0.0) && !(mid > length)) break;
                                result[index].hidden = true;
                            }
                        }
                    }
                    mid %= length;
                    if (!result[index].hidden) {
                        float[] point = new float[2];
                        float[] t = new float[2];
                        pm.getPosTan((float)mid, point, t);
                        double tau = Math.PI * 2;
                        double radToDeg = 57.29577951308232;
                        double r = Math.atan2(t[1], t[0]) * 57.29577951308232;
                        double normAngle = r + 90.0;
                        double[] n = new double[]{Math.cos(normAngle), Math.sin(normAngle)};
                        double o = 0.0;
                        result[index].rotate += r;
                    }
                } else {
                    result[index].x = result[index - 1].x;
                    result[index].y = result[index - 1].y;
                    result[index].rotate = result[index - 1].rotate;
                }
            }
            if (textPathView != null || !result[index].addressable) continue;
            if (inPath) {
                inPath = false;
                afterPath = true;
                pm.setPath(textPath, false);
                float[] pos = new float[2];
                pm.getPosTan(pm.getLength(), pos, null);
                path_end.set(pos[0], pos[1]);
            }
            if (!afterPath) continue;
            if (result[index].anchoredChunk) {
                afterPath = false;
                continue;
            }
            result[index].x += (double)path_end.x;
            result[index].y += (double)path_end.y;
        }
        return result;
    }

    class LayoutInput {
        TextView text;
        boolean horizontal;

        LayoutInput() {
        }
    }

    class CharacterInformation {
        int index;
        double x = 0.0;
        double y = 0.0;
        double advance;
        char character;
        double rotate = 0.0;
        TextView element;
        boolean hidden = false;
        boolean middle = false;
        boolean resolved = false;
        boolean xSpecified = false;
        boolean ySpecified = false;
        boolean addressable = true;
        boolean anchoredChunk = false;
        boolean rotateSpecified = false;
        boolean firstCharacterInResolvedDescendant = false;

        CharacterInformation(int index, char c) {
            this.index = index;
            this.character = c;
        }
    }
}

