/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class TextProperties {
    TextProperties() {
    }

    static enum TextPathSpacing {
        auto,
        exact;

    }

    static enum TextPathSide {
        left,
        right;

    }

    static enum TextPathMidLine {
        sharp,
        smooth;

    }

    static enum TextPathMethod {
        align,
        stretch;

    }

    static enum TextLengthAdjust {
        spacing,
        spacingAndGlyphs;

    }

    static enum TextDecoration {
        None("none"),
        Underline("underline"),
        Overline("overline"),
        LineThrough("line-through"),
        Blink("blink");

        private final String decoration;
        private static final Map<String, TextDecoration> decorationToEnum;

        private TextDecoration(String decoration) {
            this.decoration = decoration;
        }

        static TextDecoration getEnum(String strVal) {
            if (!decorationToEnum.containsKey(strVal)) {
                throw new IllegalArgumentException("Unknown String Value: " + strVal);
            }
            return decorationToEnum.get(strVal);
        }

        @Nonnull
        public String toString() {
            return this.decoration;
        }

        static {
            decorationToEnum = new HashMap<String, TextDecoration>();
            for (TextDecoration en : TextDecoration.values()) {
                decorationToEnum.put(en.decoration, en);
            }
        }
    }

    static enum TextAnchor {
        start,
        middle,
        end;

    }

    static enum FontWeight {
        Normal("normal"),
        Bold("bold"),
        w100("100"),
        w200("200"),
        w300("300"),
        w400("400"),
        w500("500"),
        w600("600"),
        w700("700"),
        w800("800"),
        w900("900"),
        Bolder("bolder"),
        Lighter("lighter");

        private final String weight;
        private static final Map<String, FontWeight> weightToEnum;

        private FontWeight(String weight) {
            this.weight = weight;
        }

        static boolean hasEnum(String strVal) {
            return weightToEnum.containsKey(strVal);
        }

        static FontWeight get(String strVal) {
            return weightToEnum.get(strVal);
        }

        @Nonnull
        public String toString() {
            return this.weight;
        }

        static {
            weightToEnum = new HashMap<String, FontWeight>();
            for (FontWeight en : FontWeight.values()) {
                weightToEnum.put(en.weight, en);
            }
        }
    }

    static enum FontStyle {
        normal,
        italic,
        oblique;

    }

    static enum FontVariantLigatures {
        normal,
        none;

    }

    static enum Direction {
        ltr,
        rtl;

    }

    static enum AlignmentBaseline {
        baseline("baseline"),
        textBottom("text-bottom"),
        alphabetic("alphabetic"),
        ideographic("ideographic"),
        middle("middle"),
        central("central"),
        mathematical("mathematical"),
        textTop("text-top"),
        bottom("bottom"),
        center("center"),
        top("top"),
        textBeforeEdge("text-before-edge"),
        textAfterEdge("text-after-edge"),
        beforeEdge("before-edge"),
        afterEdge("after-edge"),
        hanging("hanging");

        private final String alignment;
        private static final Map<String, AlignmentBaseline> alignmentToEnum;

        private AlignmentBaseline(String alignment) {
            this.alignment = alignment;
        }

        static AlignmentBaseline getEnum(String strVal) {
            if (!alignmentToEnum.containsKey(strVal)) {
                throw new IllegalArgumentException("Unknown String Value: " + strVal);
            }
            return alignmentToEnum.get(strVal);
        }

        @Nonnull
        public String toString() {
            return this.alignment;
        }

        static {
            alignmentToEnum = new HashMap<String, AlignmentBaseline>();
            for (AlignmentBaseline en : AlignmentBaseline.values()) {
                alignmentToEnum.put(en.alignment, en);
            }
        }
    }
}

