/*
 * Decompiled with CFR 0.152.
 */
package com.horcrux.svg;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.view.ReactViewGroup;
import com.horcrux.svg.ClipPathView;
import com.horcrux.svg.GlyphContext;
import com.horcrux.svg.GroupView;
import com.horcrux.svg.PathElement;
import com.horcrux.svg.PropHelper;
import com.horcrux.svg.RenderableView;
import com.horcrux.svg.SVGLength;
import com.horcrux.svg.SvgView;
import java.util.ArrayList;
import javax.annotation.Nullable;

@SuppressLint(value={"ViewConstructor"})
public abstract class VirtualView
extends ReactViewGroup {
    final ReactContext mContext;
    private static final double M_SQRT1_2l = 0.7071067811865476;
    private static final float[] sRawMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    float mOpacity = 1.0f;
    Matrix mCTM = new Matrix();
    Matrix mMatrix = new Matrix();
    Matrix mInvCTM = new Matrix();
    Matrix mInvMatrix = new Matrix();
    final Matrix mInvTransform = new Matrix();
    boolean mInvertible = true;
    boolean mCTMInvertible = true;
    private RectF mClientRect;
    int mClipRule;
    @Nullable
    private String mClipPath;
    @Nullable
    String mMask;
    @Nullable
    String mMarkerStart;
    @Nullable
    String mMarkerMid;
    @Nullable
    String mMarkerEnd;
    private static final int CLIP_RULE_EVENODD = 0;
    static final int CLIP_RULE_NONZERO = 1;
    final float mScale;
    private boolean mResponsible;
    String mDisplay;
    String mName;
    private SvgView svgView;
    private Path mCachedClipPath;
    private GroupView mTextRoot;
    private double fontSize = -1.0;
    private double canvasDiagonal = -1.0;
    private float canvasHeight = -1.0f;
    private float canvasWidth = -1.0f;
    private GlyphContext glyphContext;
    Path mPath;
    Path mFillPath;
    Path mStrokePath;
    Path mMarkerPath;
    Path mClipRegionPath;
    RectF mBox;
    RectF mFillBounds;
    RectF mStrokeBounds;
    RectF mMarkerBounds;
    RectF mClipBounds;
    Region mRegion;
    Region mMarkerRegion;
    Region mStrokeRegion;
    Region mClipRegion;
    ArrayList<PathElement> elements;
    PointerEvents mPointerEvents;

    VirtualView(ReactContext reactContext) {
        super((Context)reactContext);
        this.mContext = reactContext;
        this.mScale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
    }

    public void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (this.mClientRect != null) {
            SvgView root = this.getSvgView();
            int[] rootPositionOnScreen = new int[2];
            this.getSvgView().getLocationOnScreen(rootPositionOnScreen);
            Rect infoBoundsInScreen = new Rect();
            infoBoundsInScreen.left = rootPositionOnScreen[0] + (int)Math.floor(this.mClientRect.left);
            infoBoundsInScreen.top = rootPositionOnScreen[1] + (int)Math.floor(this.mClientRect.top);
            infoBoundsInScreen.right = infoBoundsInScreen.left + (int)Math.ceil(this.mClientRect.width());
            infoBoundsInScreen.bottom = infoBoundsInScreen.top + (int)Math.ceil(this.mClientRect.height());
            Rect rootVisibleRect = new Rect();
            boolean isRootVisible = root.getGlobalVisibleRect(rootVisibleRect);
            boolean infoIsVisibleToUser = isRootVisible && infoBoundsInScreen.intersect(rootVisibleRect);
            String infoClassName = ((Object)((Object)this)).getClass().getCanonicalName();
            info.setBoundsInScreen(infoBoundsInScreen);
            info.setClassName((CharSequence)infoClassName);
            info.setVisibleToUser(infoIsVisibleToUser);
        }
    }

    public void invalidate() {
        if (this instanceof RenderableView && this.mPath == null) {
            return;
        }
        this.clearCache();
        this.clearParentCache();
        super.invalidate();
    }

    void clearCache() {
        this.canvasDiagonal = -1.0;
        this.canvasHeight = -1.0f;
        this.canvasWidth = -1.0f;
        this.fontSize = -1.0;
        this.mStrokeRegion = null;
        this.mMarkerRegion = null;
        this.mRegion = null;
        this.mPath = null;
    }

    void clearChildCache() {
        this.clearCache();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View node = this.getChildAt(i);
            if (!(node instanceof VirtualView)) continue;
            ((VirtualView)node).clearChildCache();
        }
    }

    private void clearParentCache() {
        VirtualView node = this;
        ViewParent parent;
        while ((parent = node.getParent()) instanceof VirtualView) {
            node = (VirtualView)parent;
            if (node.mPath == null) {
                return;
            }
            node.clearCache();
        }
        return;
    }

    @Nullable
    GroupView getTextRoot() {
        VirtualView node = this;
        if (this.mTextRoot == null) {
            while (node != null) {
                if (node instanceof GroupView && ((GroupView)node).getGlyphContext() != null) {
                    this.mTextRoot = (GroupView)node;
                    break;
                }
                ViewParent parent = node.getParent();
                if (!(parent instanceof VirtualView)) {
                    node = null;
                    continue;
                }
                node = (VirtualView)parent;
            }
        }
        return this.mTextRoot;
    }

    @Nullable
    GroupView getParentTextRoot() {
        ViewParent parent = this.getParent();
        if (!(parent instanceof VirtualView)) {
            return null;
        }
        return ((VirtualView)parent).getTextRoot();
    }

    private double getFontSizeFromContext() {
        if (this.fontSize != -1.0) {
            return this.fontSize;
        }
        GroupView root = this.getTextRoot();
        if (root == null) {
            return 12.0;
        }
        if (this.glyphContext == null) {
            this.glyphContext = root.getGlyphContext();
        }
        this.fontSize = this.glyphContext.getFontSize();
        return this.fontSize;
    }

    abstract void draw(Canvas var1, Paint var2, float var3);

    void render(Canvas canvas, Paint paint, float opacity) {
        this.draw(canvas, paint, opacity);
    }

    int saveAndSetupCanvas(Canvas canvas, Matrix ctm) {
        int count = canvas.save();
        this.mCTM.set(this.mMatrix);
        canvas.concat(this.mCTM);
        this.mCTM.preConcat(ctm);
        this.mCTMInvertible = this.mCTM.invert(this.mInvCTM);
        return count;
    }

    void restoreCanvas(Canvas canvas, int count) {
        canvas.restoreToCount(count);
    }

    public void setName(String name) {
        this.mName = name;
        this.invalidate();
    }

    public void setDisplay(String display) {
        this.mDisplay = display;
        this.invalidate();
    }

    public void setMask(String mask) {
        this.mMask = mask;
        this.invalidate();
    }

    public void setMarkerStart(String markerStart) {
        this.mMarkerStart = markerStart;
        this.invalidate();
    }

    public void setMarkerMid(String markerMid) {
        this.mMarkerMid = markerMid;
        this.invalidate();
    }

    public void setMarkerEnd(String markerEnd) {
        this.mMarkerEnd = markerEnd;
        this.invalidate();
    }

    public void setClipPath(String clipPath) {
        this.mCachedClipPath = null;
        this.mClipPath = clipPath;
        this.invalidate();
    }

    public void setClipRule(int clipRule) {
        this.mClipRule = clipRule;
        this.invalidate();
    }

    public void setOpacity(float opacity) {
        this.mOpacity = opacity;
        this.invalidate();
    }

    public void setMatrix(Dynamic matrixArray) {
        boolean isArrayType = !matrixArray.isNull() && matrixArray.getType().equals((Object)ReadableType.Array);
        this.setMatrix(isArrayType ? matrixArray.asArray() : null);
    }

    public void setMatrix(@Nullable ReadableArray matrixArray) {
        if (matrixArray != null) {
            int matrixSize = PropHelper.toMatrixData(matrixArray, sRawMatrix, this.mScale);
            if (matrixSize == 6) {
                if (this.mMatrix == null) {
                    this.mMatrix = new Matrix();
                    this.mInvMatrix = new Matrix();
                }
                this.mMatrix.setValues(sRawMatrix);
                this.mInvertible = this.mMatrix.invert(this.mInvMatrix);
            } else if (matrixSize != -1) {
                FLog.w((String)"ReactNative", (String)"RNSVG: Transform matrices must be of size 6");
            }
        } else {
            this.mMatrix.reset();
            this.mInvMatrix.reset();
            this.mInvertible = true;
        }
        super.invalidate();
        this.clearParentCache();
    }

    public void setResponsible(boolean responsible) {
        this.mResponsible = responsible;
        this.invalidate();
    }

    @Nullable
    Path getClipPath() {
        return this.mCachedClipPath;
    }

    @Nullable
    Path getClipPath(Canvas canvas, Paint paint) {
        if (this.mClipPath != null) {
            ClipPathView mClipNode = (ClipPathView)this.getSvgView().getDefinedClipPath(this.mClipPath);
            if (mClipNode != null) {
                Path clipPath = this.mClipRule == 0 ? mClipNode.getPath(canvas, paint) : mClipNode.getPath(canvas, paint, Region.Op.UNION);
                clipPath.transform(mClipNode.mMatrix);
                switch (this.mClipRule) {
                    case 0: {
                        clipPath.setFillType(Path.FillType.EVEN_ODD);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        FLog.w((String)"ReactNative", (String)("RNSVG: clipRule: " + this.mClipRule + " unrecognized"));
                    }
                }
                this.mCachedClipPath = clipPath;
            } else {
                FLog.w((String)"ReactNative", (String)("RNSVG: Undefined clipPath: " + this.mClipPath));
            }
        }
        return this.getClipPath();
    }

    void clip(Canvas canvas, Paint paint) {
        Path clip = this.getClipPath(canvas, paint);
        if (clip != null) {
            canvas.clipPath(clip);
        }
    }

    abstract int hitTest(float[] var1);

    boolean isResponsible() {
        return this.mResponsible;
    }

    abstract Path getPath(Canvas var1, Paint var2);

    @Nullable
    public SvgView getSvgView() {
        if (this.svgView != null) {
            return this.svgView;
        }
        ViewParent parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof SvgView) {
            this.svgView = (SvgView)parent;
        } else if (parent instanceof VirtualView) {
            this.svgView = ((VirtualView)parent).getSvgView();
        } else {
            FLog.e((String)"ReactNative", (String)("RNSVG: " + ((Object)((Object)this)).getClass().getName() + " should be descendant of a SvgView."));
        }
        return this.svgView;
    }

    double relativeOnFraction(SVGLength length, float relative) {
        SVGLength.UnitType unit = length.unit;
        if (unit == SVGLength.UnitType.NUMBER) {
            return length.value * (double)relative;
        }
        if (unit == SVGLength.UnitType.PERCENTAGE) {
            return length.value / 100.0 * (double)relative;
        }
        return this.fromRelativeFast(length);
    }

    double relativeOn(SVGLength length, float relative) {
        SVGLength.UnitType unit = length.unit;
        if (unit == SVGLength.UnitType.NUMBER) {
            return length.value * (double)this.mScale;
        }
        if (unit == SVGLength.UnitType.PERCENTAGE) {
            return length.value / 100.0 * (double)relative;
        }
        return this.fromRelativeFast(length);
    }

    double relativeOnWidth(SVGLength length) {
        return this.relativeOn(length, this.getCanvasWidth());
    }

    double relativeOnHeight(SVGLength length) {
        return this.relativeOn(length, this.getCanvasHeight());
    }

    double relativeOnOther(SVGLength length) {
        return this.relativeOn(length, (float)this.getCanvasDiagonal());
    }

    private double fromRelativeFast(SVGLength length) {
        return length.value * (switch (length.unit) {
            case SVGLength.UnitType.EMS -> this.getFontSizeFromContext();
            case SVGLength.UnitType.EXS -> this.getFontSizeFromContext() / 2.0;
            case SVGLength.UnitType.CM -> 35.43307;
            case SVGLength.UnitType.MM -> 3.543307;
            case SVGLength.UnitType.IN -> 90.0;
            case SVGLength.UnitType.PT -> 1.25;
            case SVGLength.UnitType.PC -> 15.0;
            default -> 1.0;
        }) * (double)this.mScale;
    }

    private float getCanvasWidth() {
        if (this.canvasWidth != -1.0f) {
            return this.canvasWidth;
        }
        GroupView root = this.getTextRoot();
        this.canvasWidth = root == null ? (float)this.getSvgView().getCanvasBounds().width() : root.getGlyphContext().getWidth();
        return this.canvasWidth;
    }

    private float getCanvasHeight() {
        if (this.canvasHeight != -1.0f) {
            return this.canvasHeight;
        }
        GroupView root = this.getTextRoot();
        this.canvasHeight = root == null ? (float)this.getSvgView().getCanvasBounds().height() : root.getGlyphContext().getHeight();
        return this.canvasHeight;
    }

    private double getCanvasDiagonal() {
        if (this.canvasDiagonal != -1.0) {
            return this.canvasDiagonal;
        }
        double powX = Math.pow(this.getCanvasWidth(), 2.0);
        double powY = Math.pow(this.getCanvasHeight(), 2.0);
        this.canvasDiagonal = Math.sqrt(powX + powY) * 0.7071067811865476;
        return this.canvasDiagonal;
    }

    void saveDefinition() {
        if (this.mName != null) {
            this.getSvgView().defineTemplate(this, this.mName);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mClientRect != null ? (int)Math.ceil(this.mClientRect.width()) : VirtualView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = this.mClientRect != null ? (int)Math.ceil(this.mClientRect.height()) : VirtualView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int pleft, int ptop, int pright, int pbottom) {
        if (this.mClientRect == null) {
            return;
        }
        if (!(this instanceof GroupView)) {
            int left = (int)Math.floor(this.mClientRect.left);
            int top = (int)Math.floor(this.mClientRect.top);
            int right = (int)Math.ceil(this.mClientRect.right);
            int bottom = (int)Math.ceil(this.mClientRect.bottom);
            this.setLeft(left);
            this.setTop(top);
            this.setRight(right);
            this.setBottom(bottom);
        }
        int width = (int)Math.ceil(this.mClientRect.width());
        int height = (int)Math.ceil(this.mClientRect.height());
        this.setMeasuredDimension(width, height);
    }

    void setClientRect(RectF rect) {
        EventDispatcher eventDispatcher;
        SvgView root;
        if (this.mClientRect != null && this.mClientRect.equals((Object)rect)) {
            return;
        }
        this.mClientRect = rect;
        if (this.mClientRect == null) {
            return;
        }
        int width = (int)Math.ceil(this.mClientRect.width());
        int height = (int)Math.ceil(this.mClientRect.height());
        int left = (int)Math.floor(this.mClientRect.left);
        int top = (int)Math.floor(this.mClientRect.top);
        int right = (int)Math.ceil(this.mClientRect.right);
        int bottom = (int)Math.ceil(this.mClientRect.bottom);
        this.setMeasuredDimension(width, height);
        if (!(this instanceof GroupView) && (root = this.getSvgView()) != null) {
            this.setLeft(Math.max(left, 0));
            this.setTop(Math.max(top, 0));
            this.setRight(Math.min(right, root.getWidth()));
            this.setBottom(Math.min(bottom, root.getHeight()));
        }
        if ((eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)this.mContext, (int)this.getId())) != null) {
            eventDispatcher.dispatchEvent((Event)OnLayoutEvent.obtain((int)this.getId(), (int)left, (int)top, (int)width, (int)height));
        }
    }

    RectF getClientRect() {
        return this.mClientRect;
    }
}

